/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.images.ImageHelper;
import com.jtattoo.demo.utils.GridBagHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class TabPanePanel
extends JPanel {
    private JTabbedPane tabbedPane = null;
    private JCheckBox scrollableTabCheck = null;
    private JRadioButton topTabButton = null;
    private JRadioButton leftTabButton = null;
    private JRadioButton bottomTabButton = null;
    private JRadioButton rightTabButton = null;
    private JButton addTabButton = null;

    public TabPanePanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setName("TabPane");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel contentPanel = new JPanel(new BorderLayout());
        Color colorYellow = new Color(255, 255, 192);
        Color colorGreen = new Color(192, 255, 192);
        Color colorBlue = new Color(192, 192, 255);
        JPanel htmlPanel = new JPanel();
        JPanel yellowPanel = new JPanel();
        JPanel greenPanel = new JPanel();
        JPanel bluePanel = new JPanel();
        yellowPanel.setBackground(colorYellow);
        greenPanel.setBackground(colorGreen);
        bluePanel.setBackground(colorBlue);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.add("<html><b>HTML</b>-Tab</html>", htmlPanel);
        this.tabbedPane.setToolTipTextAt(0, "This is a HTML tab");
        this.tabbedPane.add("Yellow-Tab", yellowPanel);
        this.tabbedPane.setToolTipTextAt(1, "This tab is yellow");
        this.tabbedPane.add("Green-Tab", greenPanel);
        this.tabbedPane.setToolTipTextAt(2, "This tab is green");
        this.tabbedPane.add("Blue-Tab with a verry long text", bluePanel);
        this.tabbedPane.setToolTipTextAt(3, "This tab is blue");
        this.tabbedPane.add("Disabled-Tab", new JPanel());
        this.tabbedPane.setToolTipTextAt(4, "This is a disabled Tab");
        this.tabbedPane.setEnabledAt(4, false);
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            int tabCount = this.tabbedPane.getTabCount();
            this.tabbedPane.add("Tab", new JPanel());
            this.tabbedPane.setTabComponentAt(tabCount, new CloseableTabComponent(this.tabbedPane, tabCount));
            this.tabbedPane.setToolTipTextAt(tabCount, "This is tab No. " + (tabCount + 1));
        }
        this.tabbedPane.setBackgroundAt(1, colorYellow);
        this.tabbedPane.setForegroundAt(1, Color.red);
        this.tabbedPane.setBackgroundAt(2, colorGreen);
        this.tabbedPane.setForegroundAt(2, Color.blue);
        this.tabbedPane.setBackgroundAt(3, colorBlue);
        this.tabbedPane.setForegroundAt(3, Color.black);
        JPanel controlerPanel = new JPanel(new GridBagLayout());
        this.scrollableTabCheck = new JCheckBox("scrollable");
        this.scrollableTabCheck.setSelected(false);
        this.scrollableTabCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JTattooUtilities.getJavaVersion() >= 1.4) {
                    if (TabPanePanel.this.scrollableTabCheck.isSelected()) {
                        TabPanePanel.this.tabbedPane.setTabLayoutPolicy(1);
                    } else {
                        TabPanePanel.this.tabbedPane.setTabLayoutPolicy(0);
                    }
                }
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource().equals(TabPanePanel.this.topTabButton)) {
                    TabPanePanel.this.tabbedPane.setTabPlacement(1);
                }
                if (ev.getSource().equals(TabPanePanel.this.leftTabButton)) {
                    TabPanePanel.this.tabbedPane.setTabPlacement(2);
                }
                if (ev.getSource().equals(TabPanePanel.this.bottomTabButton)) {
                    TabPanePanel.this.tabbedPane.setTabPlacement(3);
                }
                if (ev.getSource().equals(TabPanePanel.this.rightTabButton)) {
                    TabPanePanel.this.tabbedPane.setTabPlacement(4);
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        this.topTabButton = new JRadioButton("top");
        this.leftTabButton = new JRadioButton("left");
        this.bottomTabButton = new JRadioButton("bottom");
        this.rightTabButton = new JRadioButton("right");
        group.add(this.topTabButton);
        group.add(this.leftTabButton);
        group.add(this.bottomTabButton);
        group.add(this.rightTabButton);
        this.topTabButton.setSelected(true);
        this.topTabButton.addActionListener(al);
        this.leftTabButton.addActionListener(al);
        this.bottomTabButton.addActionListener(al);
        this.rightTabButton.addActionListener(al);
        this.addTabButton = new JButton("add tab");
        this.addTabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    int tabCount = TabPanePanel.this.tabbedPane.getTabCount();
                    TabPanePanel.this.tabbedPane.add("Tab", new JPanel());
                    TabPanePanel.this.tabbedPane.setTabComponentAt(tabCount, new CloseableTabComponent(TabPanePanel.this.tabbedPane, tabCount));
                    TabPanePanel.this.tabbedPane.setToolTipTextAt(tabCount, "This is tab No. " + (tabCount + 1));
                }
            }
        });
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            GridBagHelper.addComponent(controlerPanel, this.scrollableTabCheck, 0, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        }
        GridBagHelper.addComponent(controlerPanel, this.topTabButton, 1, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        GridBagHelper.addComponent(controlerPanel, this.leftTabButton, 2, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        GridBagHelper.addComponent(controlerPanel, this.bottomTabButton, 3, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        GridBagHelper.addComponent(controlerPanel, this.rightTabButton, 4, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        GridBagHelper.addComponent(controlerPanel, new JPanel(), 5, 0, 1, 1, 0, 0, 1.0, 0.0, 2, 17);
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            GridBagHelper.addComponent(controlerPanel, this.addTabButton, 6, 0, 1, 1, 0, 0, 0.0, 0.0, 3, 17);
        }
        contentPanel.add((Component)controlerPanel, "North");
        contentPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)contentPanel, "Center");
    }

    public static class CloseableTabComponent
    extends JPanel {
        private static ImageIcon closerImage = ImageHelper.loadImage("closer.gif");
        private static ImageIcon closerRolloverImage = ImageHelper.loadImage("closer_rollover.gif");
        private static ImageIcon closerPressedImage = ImageHelper.loadImage("closer_pressed.gif");
        private JLabel titleLabel = null;
        private JButton closeButton = null;
        private JTabbedPane tabbedPane = null;
        private int tabIndex = -1;

        public CloseableTabComponent(JTabbedPane aTabbedPane, int aTabIndex) {
            super(new BorderLayout());
            this.tabbedPane = aTabbedPane;
            this.tabIndex = aTabIndex;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.titleLabel = new JLabel("close me tab " + this.tabbedPane.getTabCount() + " ");
            this.titleLabel.setOpaque(false);
            this.closeButton = new JButton(closerImage);
            this.closeButton.setRolloverIcon(closerRolloverImage);
            this.closeButton.setPressedIcon(closerPressedImage);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setBorder(BorderFactory.createEmptyBorder());
            this.closeButton.setFocusPainted(false);
            this.closeButton.setRolloverEnabled(true);
            this.closeButton.setOpaque(false);
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setPreferredSize(new Dimension(closerImage.getIconWidth(), closerImage.getIconHeight()));
            this.closeButton.setSize(new Dimension(closerImage.getIconWidth(), closerImage.getIconHeight()));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < tabbedPane.getTabCount()) {
                        if (this.equals(tabbedPane.getTabComponentAt(i))) {
                            tabbedPane.removeTabAt(i);
                            break;
                        }
                        ++i;
                    }
                }
            });
            this.add((Component)this.titleLabel, "Center");
            this.add((Component)this.closeButton, "East");
        }

        @Override
        public void paint(Graphics g) {
            Color c;
            this.titleLabel.setForeground(this.tabbedPane.getForegroundAt(this.tabIndex));
            if (this.tabbedPane != null && this.titleLabel != null && this.tabIndex >= 0 && this.tabIndex < this.tabbedPane.getTabCount() && this.tabbedPane.getSelectedIndex() == this.tabIndex && this.tabbedPane.getForegroundAt(this.tabIndex) instanceof ColorUIResource && (c = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                this.titleLabel.setForeground(c);
            }
            super.paint(g);
        }
    }
}

