/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TabDemo
extends JFrame {
    private static final int MAX_TABS = 10;
    private JTabbedPane tabPane = null;

    public TabDemo() {
        super("TabPane-Demo");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tabPane = new JTabbedPane();
        this.tabPane.setTabLayoutPolicy(1);
        int i = 0;
        while (i < 3) {
            this.tabPane.add("", new JPanel());
            this.tabPane.setTabComponentAt(i, new CloseableTabComponent(this.tabPane));
            ++i;
        }
        this.tabPane.addTab("", new JPanel());
        this.tabPane.setTabComponentAt(this.tabPane.getTabCount() - 1, new LastTabComponent(this.tabPane));
        this.tabPane.setEnabledAt(this.tabPane.getTabCount() - 1, false);
        contentPanel.add((Component)this.tabPane, "Center");
        this.setContentPane(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setSize(800, 400);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
            new TabDemo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class CloseableTabComponent
    extends JPanel {
        private static int tabNo = 0;
        private JLabel titleLabel = null;
        private JButton closeButton = null;
        private JTabbedPane tabPane = null;

        public CloseableTabComponent(JTabbedPane aTabbedPane) {
            super(new BorderLayout());
            this.tabPane = aTabbedPane;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.titleLabel = new JLabel("Tab " + ++tabNo + " ");
            this.titleLabel.setOpaque(false);
            this.closeButton = new JButton("X");
            this.closeButton.setFont(new Font("Dialog", 1, 14));
            this.closeButton.setForeground(Color.red);
            this.closeButton.setBorderPainted(false);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < tabPane.getTabCount()) {
                        if (this.equals(tabPane.getTabComponentAt(i))) {
                            tabPane.removeTabAt(i);
                            break;
                        }
                        ++i;
                    }
                    if (tabPane.getTabCount() > 1 && tabPane.getSelectedIndex() == tabPane.getTabCount() - 1) {
                        tabPane.setSelectedIndex(tabPane.getTabCount() - 2);
                    }
                }
            });
            this.add((Component)this.titleLabel, "Center");
            this.add((Component)this.closeButton, "East");
        }
    }

    private static class LastTabComponent
    extends JPanel {
        private JButton addButton = null;
        private JTabbedPane tabPane = null;

        public LastTabComponent(JTabbedPane aTabbedPane) {
            super(new BorderLayout());
            this.tabPane = aTabbedPane;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.addButton = new JButton("+");
            this.addButton.setFont(new Font("Dialog", 1, 14));
            this.addButton.setForeground(Color.blue);
            this.addButton.setBorderPainted(false);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tabPane.getTabCount() < 10) {
                        int tabIndex = tabPane.getTabCount() - 1;
                        tabPane.insertTab("Tab", null, new JPanel(), null, tabIndex);
                        tabPane.setTabComponentAt(tabIndex, new CloseableTabComponent(tabPane));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (tabPane.getTabCount() > 1) {
                                    tabPane.setSelectedIndex(tabPane.getTabCount() - 2);
                                }
                            }
                        });
                    }
                }
            });
            this.add((Component)this.addButton, "East");
        }
    }
}

