/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.images.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel {
    private ImagePanel imagePanel = null;
    private JSlider horZoomSlider = null;
    private JSlider verZoomSlider = null;

    public SliderPanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setName("Sliders");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.imagePanel = new ImagePanel();
        this.horZoomSlider = new JSlider(0, 50, 200, 100);
        this.horZoomSlider.setMajorTickSpacing(10);
        this.horZoomSlider.setMinorTickSpacing(5);
        this.horZoomSlider.setPaintLabels(true);
        this.horZoomSlider.setPaintTicks(true);
        this.horZoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderPanel.this.imagePanel.setHorScale(((JSlider)e.getSource()).getValue());
            }
        });
        this.verZoomSlider = new JSlider(1, 50, 200, 100);
        this.verZoomSlider.setMajorTickSpacing(10);
        this.verZoomSlider.setMinorTickSpacing(5);
        this.verZoomSlider.setPaintLabels(true);
        this.verZoomSlider.setPaintTicks(true);
        this.verZoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderPanel.this.imagePanel.setVerScale(((JSlider)e.getSource()).getValue());
            }
        });
        this.add((Component)this.imagePanel, "Center");
        this.add((Component)this.horZoomSlider, "South");
        this.add((Component)this.verZoomSlider, "East");
    }

    private class ImagePanel
    extends JPanel {
        private ImageIcon fishImage = ImageHelper.loadImage("fish.gif");
        private int horScale = 100;
        private int verScale = 100;

        public ImagePanel() {
            this.setBackground(Color.white);
        }

        public void setHorScale(int scale) {
            this.horScale = scale;
            this.repaint();
        }

        public void setVerScale(int scale) {
            this.verScale = scale;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int wi = this.fishImage.getIconWidth() * this.horScale / 100;
            int hi = this.fishImage.getIconHeight() * this.verScale / 100;
            int x = (w - wi) / 2;
            int y = (h - hi) / 2;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            g.drawImage(this.fishImage.getImage(), x, y, wi, hi, this.getBackground(), null);
        }
    }
}

