/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.plaf.aero.AeroLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;

public class MaxApp
extends JFrame {
    public MaxApp() {
        super("Maximize-Test");
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder("Test"));
        this.getContentPane().add(panel);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("First", new JPanel());
        tabPane.addTab("Second", new JPanel());
        tabPane.addTab("Third", new JPanel());
        tabPane.setEnabledAt(1, false);
        panel.add((Component)tabPane, "Center");
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
        this.calculateBounds();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("windowMoved".equals(evt.getPropertyName())) {
                    MaxApp.this.calculateBounds();
                }
            }
        });
    }

    private void calculateBounds() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        screenInsets.bottom = Math.max(screenInsets.bottom, 1);
        int maxWidth = screenBounds.width - (screenInsets.left + screenInsets.right);
        int maxHeight = screenBounds.height - (screenInsets.top + screenInsets.bottom);
        this.setTitle("Maximize-Test -- ScreenWidth = " + screenBounds.width + " ScreenHeight = " + screenBounds.height + " -- MaxWidth = " + maxWidth + " MaxHeight = " + maxHeight);
    }

    public void maximize() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle screenBounds = gc.getBounds();
        int x = Math.max(0, screenInsets.left);
        int y = Math.max(0, screenInsets.top);
        int w = screenBounds.width - (screenInsets.left + screenInsets.right);
        int h = screenBounds.height - (screenInsets.top + screenInsets.bottom);
        this.setMaximizedBounds(new Rectangle(x, y, w, h));
        this.setExtendedState(6);
        if (this.getSize().width > screenBounds.width || this.getSize().height > screenBounds.height) {
            this.setMaximizedBounds(null);
            int state = this.getExtendedState();
            this.setExtendedState(state & 0xFFFFFFF9);
            this.setExtendedState(6);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new AeroLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        MaxApp app = new MaxApp();
        app.setVisible(true);
        app.maximize();
    }
}

