/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.border.JTBorderFactory;
import com.jtattoo.demo.app.GUIProperties;
import com.jtattoo.demo.app.IDemoApp;
import com.jtattoo.demo.images.ImageHelper;
import com.jtattoo.demo.utils.GridBagHelper;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import com.jtattoo.plaf.texture.TextureLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LeftPanel
extends JPanel {
    private Component parent = null;
    private IDemoApp demoApp = null;
    private JScrollPane treePanel = null;
    private JScrollPane listPanel = null;
    private JScrollPane controlPanel = null;
    private JList themesList = null;
    private JCheckBox taaCheck = null;
    private JCheckBox leftToRightCheck = null;
    private JCheckBox scrollableTabCheck = null;
    private JCheckBox patternCheck = null;
    private JCheckBox centerWindowTitleCheck = null;
    private JCheckBox macStyleWindowDecorationCheck = null;
    private JCheckBox linuxStyleScrollbarsCheck = null;
    private JRadioButton topTabButton = null;
    private JRadioButton leftTabButton = null;
    private JRadioButton bottomTabButton = null;
    private JRadioButton rightTabButton = null;
    private JSplitPane innerSplitPane = null;
    private JSplitPane outerSplitPane = null;
    private ListSelectionListener themeListener = null;
    private boolean initialized = false;

    public LeftPanel(Component aParent) {
        super(new BorderLayout());
        this.parent = aParent;
        this.demoApp = (IDemoApp)((Object)this.parent);
        this.init();
        this.initialized = true;
    }

    @Override
    public void updateUI() {
        if (this.initialized) {
            if (UIManager.getLookAndFeel().getName().equals("Texture")) {
                Border innerBorder = JTBorderFactory.createTitleBorder(ImageHelper.loadImage("tree.gif"), "Tree-Demo", 0, 0);
                Border outerBorder = BorderFactory.createEmptyBorder(4, 8, 4, 0);
                this.treePanel.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
                this.treePanel.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
                innerBorder = JTBorderFactory.createTitleBorder(ImageHelper.loadImage("themes.gif"), "Themes-List", 0, 0);
                this.listPanel.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
                this.listPanel.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
                innerBorder = JTBorderFactory.createTitleBorder(null, "Controls", 0, 0);
                this.controlPanel.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
                this.controlPanel.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
            } else {
                this.treePanel.setBorder(JTBorderFactory.createTitleBorder(ImageHelper.loadImage("tree.gif"), "Tree-Demo", 0, 0));
                this.listPanel.setBorder(JTBorderFactory.createTitleBorder(ImageHelper.loadImage("themes.gif"), "Themes-List", 0, 0));
                this.controlPanel.setBorder(JTBorderFactory.createTitleBorder(null, "Controls", 0, 0));
            }
        }
        super.updateUI();
    }

    private void init() {
        this.initControls();
    }

    private void initControls() {
        this.treePanel = this.createTree();
        this.treePanel.setMinimumSize(new Dimension(80, 60));
        this.listPanel = this.createList();
        this.listPanel.setMinimumSize(new Dimension(80, 60));
        this.controlPanel = this.createControl();
        this.controlPanel.setMinimumSize(new Dimension(80, 60));
        this.innerSplitPane = new JSplitPane(0, true, this.treePanel, this.listPanel);
        this.innerSplitPane.setDividerLocation(160);
        this.innerSplitPane.setMinimumSize(new Dimension(100, 100));
        this.innerSplitPane.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
        this.outerSplitPane = new JSplitPane(0, true, this.innerSplitPane, this.controlPanel);
        this.outerSplitPane.setDividerLocation(360);
        this.outerSplitPane.setMinimumSize(new Dimension(100, 200));
        this.outerSplitPane.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
        this.add((Component)this.outerSplitPane, "Center");
    }

    private JScrollPane createTree() {
        JTree tree = new JTree(){

            @Override
            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setBorder(JTBorderFactory.createTitleBorder(ImageHelper.loadImage("tree.gif"), "Tree-Demo", 0, 0));
        return scrollPane;
    }

    private JScrollPane createList() {
        this.themesList = new JList(){

            @Override
            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.themeListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    LeftPanel.this.updateTheme();
                }
            }
        };
        this.fillThemesList();
        JScrollPane scrollPane = new JScrollPane(this.themesList);
        scrollPane.setBorder(JTBorderFactory.createTitleBorder(ImageHelper.loadImage("themes.gif"), "Themes-List", 0, 0));
        return scrollPane;
    }

    private JScrollPane createControl() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.taaCheck = new JCheckBox("textAntiAliasing");
        this.taaCheck.setSelected(false);
        this.taaCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.demoApp.setLookAndFeelFlag("textAntiAliasing", LeftPanel.this.taaCheck.isSelected());
            }
        });
        this.leftToRightCheck = new JCheckBox("left to right");
        this.leftToRightCheck.setSelected(true);
        this.leftToRightCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JTattooUtilities.getJavaVersion() >= 1.4) {
                    if (LeftPanel.this.leftToRightCheck.isSelected()) {
                        LeftPanel.this.parent.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    } else {
                        LeftPanel.this.parent.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    }
                    LeftPanel.this.parent.validate();
                    LeftPanel.this.parent.repaint();
                }
            }
        });
        this.scrollableTabCheck = new JCheckBox("scrollable tabs");
        this.scrollableTabCheck.setSelected(false);
        this.scrollableTabCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JTattooUtilities.getJavaVersion() >= 1.4) {
                    if (LeftPanel.this.scrollableTabCheck.isSelected()) {
                        LeftPanel.this.demoApp.getMainTabbedPane().setTabLayoutPolicy(1);
                    } else {
                        LeftPanel.this.demoApp.getMainTabbedPane().setTabLayoutPolicy(0);
                    }
                }
            }
        });
        this.patternCheck = new JCheckBox("backgroundPattern");
        this.patternCheck.setSelected(true);
        this.patternCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.demoApp.setLookAndFeelFlag("backgroundPattern", LeftPanel.this.patternCheck.isSelected());
            }
        });
        this.centerWindowTitleCheck = new JCheckBox("centerWindowTitle");
        this.centerWindowTitleCheck.setSelected(true);
        this.centerWindowTitleCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeftPanel.this.demoApp.setLookAndFeelFlag("centerWindowTitle", LeftPanel.this.centerWindowTitleCheck.isSelected());
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource().equals(LeftPanel.this.topTabButton)) {
                    LeftPanel.this.demoApp.getMainTabbedPane().setTabPlacement(1);
                }
                if (ev.getSource().equals(LeftPanel.this.leftTabButton)) {
                    LeftPanel.this.demoApp.getMainTabbedPane().setTabPlacement(2);
                }
                if (ev.getSource().equals(LeftPanel.this.bottomTabButton)) {
                    LeftPanel.this.demoApp.getMainTabbedPane().setTabPlacement(3);
                }
                if (ev.getSource().equals(LeftPanel.this.rightTabButton)) {
                    LeftPanel.this.demoApp.getMainTabbedPane().setTabPlacement(4);
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        this.topTabButton = new JRadioButton("top tab placement");
        this.leftTabButton = new JRadioButton("left tab placement");
        this.bottomTabButton = new JRadioButton("bottom tab placement");
        this.rightTabButton = new JRadioButton("right tab placement");
        group.add(this.topTabButton);
        group.add(this.leftTabButton);
        group.add(this.bottomTabButton);
        group.add(this.rightTabButton);
        this.topTabButton.setSelected(true);
        this.topTabButton.addActionListener(al);
        this.leftTabButton.addActionListener(al);
        this.bottomTabButton.addActionListener(al);
        this.rightTabButton.addActionListener(al);
        int row = 0;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            GridBagHelper.addComponent(panel, this.taaCheck, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        }
        GridBagHelper.addComponent(panel, this.leftToRightCheck, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            GridBagHelper.addComponent(panel, this.scrollableTabCheck, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        }
        GridBagHelper.addComponent(panel, this.patternCheck, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, this.centerWindowTitleCheck, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JSeparator(), 0, row++, 1, 1, 0, 0, 1.0, 0.0, 2, 10);
        GridBagHelper.addComponent(panel, this.topTabButton, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, this.leftTabButton, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, this.bottomTabButton, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, this.rightTabButton, 0, row++, 1, 1, 0, 0, 0.0, 0.0, 2, 17);
        GridBagHelper.addComponent(panel, new JPanel(), 0, row++, 1, 1, 0, 0, 0.0, 1.0, 3, 17);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(JTBorderFactory.createTitleBorder(null, "Controls", 0, 0));
        return scrollPane;
    }

    public void updateLookAndFeel() {
        this.fillThemesList();
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof AbstractLookAndFeel) {
            this.taaCheck.setSelected(AbstractLookAndFeel.getTheme().isTextAntiAliasingOn());
            this.patternCheck.setSelected(AbstractLookAndFeel.getTheme().isBackgroundPatternOn());
            this.centerWindowTitleCheck.setSelected(AbstractLookAndFeel.getTheme().isCenterWindowTitleOn());
        } else {
            this.taaCheck.setSelected(false);
            this.patternCheck.setSelected(false);
            this.centerWindowTitleCheck.setSelected(false);
        }
    }

    private void fillThemesList() {
        this.themesList.removeListSelectionListener(this.themeListener);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof AcrylLookAndFeel) {
            this.themesList.setListData(AcrylLookAndFeel.getThemes().toArray());
        } else if (laf instanceof AeroLookAndFeel) {
            this.themesList.setListData(AeroLookAndFeel.getThemes().toArray());
        } else if (laf instanceof AluminiumLookAndFeel) {
            this.themesList.setListData(AluminiumLookAndFeel.getThemes().toArray());
        } else if (laf instanceof BernsteinLookAndFeel) {
            this.themesList.setListData(BernsteinLookAndFeel.getThemes().toArray());
        } else if (laf instanceof FastLookAndFeel) {
            this.themesList.setListData(FastLookAndFeel.getThemes().toArray());
        } else if (laf instanceof GraphiteLookAndFeel) {
            this.themesList.setListData(GraphiteLookAndFeel.getThemes().toArray());
        } else if (laf instanceof HiFiLookAndFeel) {
            this.themesList.setListData(HiFiLookAndFeel.getThemes().toArray());
        } else if (laf instanceof LunaLookAndFeel) {
            this.themesList.setListData(LunaLookAndFeel.getThemes().toArray());
        } else if (laf instanceof McWinLookAndFeel) {
            this.themesList.setListData(McWinLookAndFeel.getThemes().toArray());
        } else if (laf instanceof MintLookAndFeel) {
            this.themesList.setListData(MintLookAndFeel.getThemes().toArray());
        } else if (laf instanceof NoireLookAndFeel) {
            this.themesList.setListData(NoireLookAndFeel.getThemes().toArray());
        } else if (laf instanceof SmartLookAndFeel) {
            this.themesList.setListData(SmartLookAndFeel.getThemes().toArray());
        } else if (laf instanceof TextureLookAndFeel) {
            this.themesList.setListData(TextureLookAndFeel.getThemes().toArray());
        } else {
            this.themesList.setListData(new Vector());
        }
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            this.themesList.setSelectedValue(AbstractLookAndFeel.getTheme().getName(), true);
        }
        this.themesList.addListSelectionListener(this.themeListener);
    }

    private void updateTheme() {
        final String theme = (String)this.themesList.getSelectedValue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((IDemoApp)((Object)LeftPanel.this.parent)).updateTheme(theme);
            }
        });
    }
}

