/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JXTrayIcon
extends TrayIcon {
    private JPopupMenu menu;
    private static JXTrayIcon trayIcon = null;
    private static final JDialog dialog = new JDialog(null, "TrayDialog");
    private static PopupMenuListener popupListener;

    static {
        dialog.setUndecorated(true);
        dialog.setAlwaysOnTop(true);
        popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(false);
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(false);
                    }
                });
            }
        };
    }

    public JXTrayIcon(Image image) {
        super(image);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }
        });
    }

    private void showJPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.menu != null) {
            Dimension size = this.menu.getPreferredSize();
            dialog.setBounds(e.getX(), e.getY(), size.width, size.height);
            dialog.setVisible(true);
            this.menu.show(dialog.getContentPane(), 0, 0);
            dialog.toFront();
        }
    }

    public JPopupMenu getJPopuMenu() {
        return this.menu;
    }

    public void setJPopuMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(popupListener);
        }
        this.menu = menu;
        menu.addPopupMenuListener(popupListener);
    }

    private static void createGui() {
        trayIcon = new JXTrayIcon(JXTrayIcon.createImage());
        trayIcon.setJPopuMenu(JXTrayIcon.createJPopupMenu());
        try {
            SystemTray.getSystemTray().add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    static Image createImage() {
        BufferedImage i = new BufferedImage(32, 32, 2);
        Graphics2D g2 = (Graphics2D)i.getGraphics();
        g2.setColor(Color.RED);
        g2.fill(new Ellipse2D.Float(0.0f, 0.0f, i.getWidth(), i.getHeight()));
        g2.dispose();
        return i;
    }

    static JPopupMenu createJPopupMenu() {
        JPopupMenu m = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Item 1");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("bin drin");
                trayIcon.displayMessage("JXTrayIcon", "Hello World", TrayIcon.MessageType.ERROR);
            }
        });
        m.add(menuItem);
        m.add(new JMenuItem("Item 2"));
        JMenu submenu = new JMenu("Submenu");
        submenu.add(new JMenuItem("item 1"));
        submenu.add(new JMenuItem("item 2"));
        submenu.add(new JMenuItem("item 3"));
        submenu.add(new JMenuItem("item 4"));
        submenu.add(new JMenuItem("item 5"));
        submenu.add(new JMenuItem("item 6"));
        submenu.add(new JMenuItem("item 7"));
        submenu.add(new JMenuItem("item 8"));
        submenu.add(new JMenuItem("item 9"));
        m.add(submenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        m.add(exitItem);
        return m;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JXTrayIcon.createGui();
            }
        });
    }
}

