/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.app.GUIProperties;
import com.jtattoo.demo.app.IDemoApp;
import com.jtattoo.demo.app.LeftPanel;
import com.jtattoo.demo.app.MainMenuBar;
import com.jtattoo.demo.app.MainToolBar;
import com.jtattoo.demo.app.RightPanel;
import com.jtattoo.demo.app.SplashPanel;
import com.jtattoo.demo.images.ImageHelper;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import com.jtattoo.plaf.texture.TextureLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class JTattooDemo
extends JFrame
implements IDemoApp {
    public static JTattooDemo app = null;
    public static GUIProperties guiProps = new GUIProperties();
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static final Dimension appSize = new Dimension(880, 660);
    private static final int appPosX = JTattooDemo.screenSize.width / 2 - JTattooDemo.appSize.width / 2;
    private static final int appPosY = JTattooDemo.screenSize.height / 2 - JTattooDemo.appSize.height / 2;
    private static Rectangle appBounds = new Rectangle(appPosX, appPosY, JTattooDemo.appSize.width, JTattooDemo.appSize.height);
    private static final String appTitle = "JTattoo - Demo";
    private JWindow splashScreen = null;
    private SplashPanel splashPanel = null;
    private MainMenuBar menuBar = null;
    private MainToolBar toolBar = null;
    private JPanel contentPanel = null;
    private LeftPanel leftPanel = null;
    private RightPanel rightPanel = null;
    private JSplitPane splitPane = null;
    private JTabbedPane mainTabbedPane = null;

    public JTattooDemo() {
        super(appTitle);
        this.init();
    }

    public JTattooDemo(Rectangle bounds) {
        super(appTitle);
        appBounds = bounds;
        this.init();
    }

    @Override
    public void performExit() {
        System.exit(0);
    }

    private void init() {
        this.splashPanel = new SplashPanel();
        this.splashScreen = new JWindow();
        this.splashScreen.getContentPane().add(this.splashPanel);
        this.splashScreen.pack();
        Dimension size = this.splashScreen.getSize();
        this.splashScreen.setLocation(JTattooDemo.screenSize.width / 2 - size.width / 2, JTattooDemo.screenSize.height / 2 - size.height / 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTattooDemo.this.splashScreen.setVisible(true);
            }
        });
        this.initModel();
        this.initMenuBar();
        this.initToolBar();
        this.initContentPane();
        this.initListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTattooDemo.this.showApp();
                if (JTattooDemo.this.splashScreen != null) {
                    JTattooDemo.this.splashScreen.setVisible(false);
                }
            }
        });
    }

    private void initModel() {
    }

    private void initMenuBar() {
        this.menuBar = new MainMenuBar(this);
        this.setJMenuBar(this.menuBar);
    }

    private void initToolBar() {
        this.toolBar = new MainToolBar();
        this.toolBar.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
    }

    private void initContentPane() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.leftPanel = new LeftPanel(this);
        this.rightPanel = new RightPanel(this);
        this.splitPane = new JSplitPane(1, true, this.leftPanel, this.rightPanel);
        this.splitPane.setDividerLocation(180);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.putClientProperty("textureType", GUIProperties.TEXTURE_TYPE);
        this.contentPanel.add((Component)this.toolBar, "North");
        this.contentPanel.add((Component)this.splitPane, "Center");
        this.setContentPane(this.contentPanel);
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JTattooDemo.this.performExit();
            }
        });
    }

    private void showApp() {
        this.setIconImage(ImageHelper.loadImage("logo.gif").getImage());
        this.setBounds(appBounds);
        this.setVisible(true);
    }

    @Override
    public GUIProperties getGuiProps() {
        return guiProps;
    }

    @Override
    public void setMainTabbedPane(JTabbedPane tabPane) {
        this.mainTabbedPane = tabPane;
    }

    @Override
    public JTabbedPane getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    private void updateComponentTree() {
        this.getRootPane().updateUI();
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            Window[] windows = Window.getWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i].isDisplayable()) {
                    SwingUtilities.updateComponentTreeUI(windows[i]);
                }
                ++i;
            }
        } else {
            Frame[] frames = Frame.getFrames();
            int i = 0;
            while (i < frames.length) {
                if (frames[i].isDisplayable()) {
                    SwingUtilities.updateComponentTreeUI(frames[i]);
                }
                ++i;
            }
        }
        this.menuBar.updateLookAndFeel();
        this.leftPanel.updateLookAndFeel();
        this.rightPanel.updateLookAndFeel();
    }

    @Override
    public void updateLookAndFeel(String lf) {
        try {
            LookAndFeel oldLAF = UIManager.getLookAndFeel();
            boolean oldDecorated = false;
            if (oldLAF instanceof MetalLookAndFeel) {
                oldDecorated = true;
            }
            if (oldLAF instanceof AbstractLookAndFeel) {
                oldDecorated = AbstractLookAndFeel.getTheme().isWindowDecorationOn();
            }
            if (lf.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            } else if (lf.equals("com.jtattoo.plaf.acryl.AcrylLookAndFeel")) {
                AcrylLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.aero.AeroLookAndFeel")) {
                AeroLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.aluminium.AluminiumLookAndFeel")) {
                AluminiumLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.bernstein.BernsteinLookAndFeel")) {
                BernsteinLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.fast.FastLookAndFeel")) {
                FastLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.graphite.GraphiteLookAndFeel")) {
                GraphiteLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.hifi.HiFiLookAndFeel")) {
                HiFiLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.luna.LunaLookAndFeel")) {
                LunaLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.mcwin.McWinLookAndFeel")) {
                McWinLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.mint.MintLookAndFeel")) {
                MintLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.noire.NoireLookAndFeel")) {
                NoireLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.smart.SmartLookAndFeel")) {
                SmartLookAndFeel.setTheme("Default");
            } else if (lf.equals("com.jtattoo.plaf.texture.TextureLookAndFeel")) {
                TextureLookAndFeel.setTheme("Default");
            } else {
                lf.equals("com.jtattoo.plaf.custom.flx.FLXLookAndFeel");
            }
            guiProps.setTheme("Default");
            guiProps.setLookAndFeel(lf);
            UIManager.setLookAndFeel(guiProps.getLookAndFeel());
            LookAndFeel newLAF = UIManager.getLookAndFeel();
            boolean newDecorated = false;
            if (newLAF instanceof MetalLookAndFeel) {
                newDecorated = true;
            }
            if (newLAF instanceof AbstractLookAndFeel) {
                newDecorated = AbstractLookAndFeel.getTheme().isWindowDecorationOn();
            }
            if (oldDecorated != newDecorated) {
                Rectangle savedBounds = this.getBounds();
                app.dispose();
                app = new JTattooDemo(savedBounds);
                app.setBounds(savedBounds);
            } else {
                this.updateComponentTree();
            }
        }
        catch (Exception ex) {
            System.out.println("Failed loading L&F: " + guiProps.getLookAndFeel() + " Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void updateTheme(String theme) {
        if (theme != null) {
            try {
                guiProps.setTheme(theme);
                LookAndFeel laf = UIManager.getLookAndFeel();
                if (laf instanceof AcrylLookAndFeel) {
                    AcrylLookAndFeel.setTheme(theme);
                } else if (laf instanceof AeroLookAndFeel) {
                    AeroLookAndFeel.setTheme(theme);
                } else if (laf instanceof AluminiumLookAndFeel) {
                    AluminiumLookAndFeel.setTheme(theme);
                } else if (laf instanceof BernsteinLookAndFeel) {
                    BernsteinLookAndFeel.setTheme(theme);
                } else if (laf instanceof FastLookAndFeel) {
                    FastLookAndFeel.setTheme(theme);
                } else if (laf instanceof GraphiteLookAndFeel) {
                    GraphiteLookAndFeel.setTheme(theme);
                } else if (laf instanceof HiFiLookAndFeel) {
                    HiFiLookAndFeel.setTheme(theme);
                } else if (laf instanceof LunaLookAndFeel) {
                    LunaLookAndFeel.setTheme(theme);
                } else if (laf instanceof McWinLookAndFeel) {
                    McWinLookAndFeel.setTheme(theme);
                } else if (laf instanceof MintLookAndFeel) {
                    MintLookAndFeel.setTheme(theme);
                } else if (laf instanceof NoireLookAndFeel) {
                    NoireLookAndFeel.setTheme(theme);
                } else if (laf instanceof SmartLookAndFeel) {
                    SmartLookAndFeel.setTheme(theme);
                } else if (laf instanceof TextureLookAndFeel) {
                    TextureLookAndFeel.setTheme(theme);
                } else if (laf instanceof MetalLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                }
                UIManager.setLookAndFeel(guiProps.getLookAndFeel());
                this.updateComponentTree();
            }
            catch (Exception ex) {
                System.out.println("Failed setting theme! Exception: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void setLookAndFeelFlag(String propName, boolean flag) {
        try {
            LookAndFeel laf = UIManager.getLookAndFeel();
            String themeName = guiProps.getTheme();
            Properties props = null;
            if (laf instanceof AcrylLookAndFeel) {
                props = AcrylLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                AcrylLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof AeroLookAndFeel) {
                props = AeroLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                AeroLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof AluminiumLookAndFeel) {
                props = AluminiumLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                AluminiumLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof BernsteinLookAndFeel) {
                props = BernsteinLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                BernsteinLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof FastLookAndFeel) {
                props = FastLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                FastLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof GraphiteLookAndFeel) {
                props = GraphiteLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                GraphiteLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof HiFiLookAndFeel) {
                props = HiFiLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                HiFiLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof LunaLookAndFeel) {
                props = LunaLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                LunaLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof McWinLookAndFeel) {
                props = McWinLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                McWinLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof MintLookAndFeel) {
                props = MintLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                MintLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof NoireLookAndFeel) {
                props = NoireLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                NoireLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof SmartLookAndFeel) {
                props = SmartLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                SmartLookAndFeel.setCurrentTheme(props);
            } else if (laf instanceof TextureLookAndFeel) {
                props = TextureLookAndFeel.getThemeProperties(themeName);
                props.put(propName, flag ? "on" : "off");
                TextureLookAndFeel.setCurrentTheme(props);
            }
            if (props != null) {
                UIManager.setLookAndFeel(laf);
                this.updateComponentTree();
            }
        }
        catch (Exception ex) {
            System.out.println("Failed setting theme! Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ToolTipManager.sharedInstance().setInitialDelay(500);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            ToolTipManager.sharedInstance().setReshowDelay(0);
            AcrylLookAndFeel.setTheme("Default");
            UIManager.setLookAndFeel(guiProps.getLookAndFeel());
            app = new JTattooDemo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

