/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.images.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InternalFramePanel
extends JPanel {
    public static Dimension HGAP2 = new Dimension(2, 1);
    public static Dimension VGAP2 = new Dimension(1, 2);
    public static Dimension HGAP5 = new Dimension(5, 1);
    public static Dimension VGAP5 = new Dimension(1, 5);
    public static Dimension HGAP10 = new Dimension(10, 1);
    public static Dimension VGAP10 = new Dimension(1, 10);
    public static Dimension HGAP15 = new Dimension(15, 1);
    public static Dimension VGAP15 = new Dimension(1, 15);
    public static Dimension HGAP20 = new Dimension(20, 1);
    public static Dimension VGAP20 = new Dimension(1, 20);
    public static Dimension HGAP25 = new Dimension(25, 1);
    public static Dimension VGAP25 = new Dimension(1, 25);
    public static Dimension HGAP30 = new Dimension(30, 1);
    public static Dimension VGAP30 = new Dimension(1, 30);
    private JDesktopPane desktopPane = null;
    private int windowCount = 0;
    private ImageIcon icon1;
    private ImageIcon icon2;
    private ImageIcon icon3;
    private ImageIcon icon4;
    private ImageIcon smIcon1;
    private ImageIcon smIcon2;
    private ImageIcon smIcon3;
    private ImageIcon smIcon4;
    public Integer FIRST_FRAME_LAYER = new Integer(1);
    public Integer DEMO_FRAME_LAYER = new Integer(2);
    public Integer PALETTE_LAYER = new Integer(3);
    public int FRAME0_X = 15;
    public int FRAME0_Y = 280;
    public int FRAME0_WIDTH = 320;
    public int FRAME0_HEIGHT = 230;
    public int FRAME_WIDTH = 225;
    public int FRAME_HEIGHT = 150;
    public int PALETTE_X = 375;
    public int PALETTE_Y = 20;
    public int PALETTE_WIDTH = 260;
    public int PALETTE_HEIGHT = 230;
    JCheckBox windowResizable = null;
    JCheckBox windowClosable = null;
    JCheckBox windowIconifiable = null;
    JCheckBox windowMaximizable = null;
    JTextField windowTitleField = null;
    JLabel windowTitleLabel = null;

    public InternalFramePanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setName("Frames");
        this.initControls();
    }

    private void initControls() {
        this.icon1 = ImageHelper.loadImage("fish.gif");
        this.icon2 = ImageHelper.loadImage("moon.gif");
        this.icon3 = ImageHelper.loadImage("sun.gif");
        this.icon4 = ImageHelper.loadImage("cab.gif");
        this.smIcon1 = ImageHelper.loadImage("fish_small.gif");
        this.smIcon2 = ImageHelper.loadImage("moon_small.gif");
        this.smIcon3 = ImageHelper.loadImage("sun_small.gif");
        this.smIcon4 = ImageHelper.loadImage("cab_small.gif");
        this.desktopPane = new JDesktopPane();
        this.add((Component)this.desktopPane, "Center");
        this.createInternalFramePalette();
        JInternalFrame frame1 = this.createInternalFrame(this.icon1, this.FIRST_FRAME_LAYER, 1, 1);
        frame1.setBounds(this.FRAME0_X, this.FRAME0_Y, this.FRAME0_WIDTH, this.FRAME0_HEIGHT);
        frame1.setFrameIcon(this.icon1);
        this.createInternalFrame(this.icon1, this.DEMO_FRAME_LAYER, this.FRAME_WIDTH, this.FRAME_HEIGHT);
        this.createInternalFrame(this.icon3, this.DEMO_FRAME_LAYER, this.FRAME_WIDTH, this.FRAME_HEIGHT);
        this.createInternalFrame(this.icon4, this.DEMO_FRAME_LAYER, this.FRAME_WIDTH, this.FRAME_HEIGHT);
        this.createInternalFrame(this.icon2, this.DEMO_FRAME_LAYER, this.FRAME_WIDTH, this.FRAME_HEIGHT);
    }

    public JInternalFrame createInternalFrame(Icon icon, Integer layer, int width, int height) {
        JInternalFrame jif = new JInternalFrame();
        if (!this.windowTitleField.getText().equals("Internal-Frame")) {
            jif.setTitle(this.windowTitleField.getText());
        } else {
            jif = new JInternalFrame("Internal-Frame " + this.windowCount);
        }
        jif.setClosable(this.windowClosable.isSelected());
        jif.setMaximizable(this.windowMaximizable.isSelected());
        jif.setIconifiable(this.windowIconifiable.isSelected());
        jif.setResizable(this.windowResizable.isSelected());
        jif.setBounds(20 * (this.windowCount % 10), 20 * (this.windowCount % 10), width, height);
        jif.setContentPane(new ImageScroller(icon, 0, this.windowCount));
        ++this.windowCount;
        this.desktopPane.add((Component)jif, layer);
        try {
            jif.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        jif.show();
        return jif;
    }

    public JInternalFrame createInternalFramePalette() {
        JInternalFrame palette = new JInternalFrame("Palette");
        palette.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        palette.getContentPane().setLayout(new BorderLayout());
        palette.setBounds(this.PALETTE_X, this.PALETTE_Y, this.PALETTE_WIDTH, this.PALETTE_HEIGHT);
        palette.setResizable(true);
        palette.setIconifiable(true);
        this.desktopPane.add((Component)palette, this.PALETTE_LAYER);
        JButton b1 = new JButton(this.smIcon1);
        JButton b2 = new JButton(this.smIcon2);
        JButton b3 = new JButton(this.smIcon3);
        JButton b4 = new JButton(this.smIcon4);
        b1.addActionListener(new ShowFrameAction(this, this.icon1));
        b2.addActionListener(new ShowFrameAction(this, this.icon2));
        b3.addActionListener(new ShowFrameAction(this, this.icon3));
        b4.addActionListener(new ShowFrameAction(this, this.icon4));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel buttons1 = new JPanel();
        buttons1.setLayout(new BoxLayout(buttons1, 0));
        JPanel buttons2 = new JPanel();
        buttons2.setLayout(new BoxLayout(buttons2, 0));
        buttons1.add(b1);
        buttons1.add(Box.createRigidArea(HGAP15));
        buttons1.add(b2);
        buttons2.add(b3);
        buttons2.add(Box.createRigidArea(HGAP15));
        buttons2.add(b4);
        p.add(Box.createRigidArea(VGAP10));
        p.add(buttons1);
        p.add(Box.createRigidArea(VGAP15));
        p.add(buttons2);
        p.add(Box.createRigidArea(VGAP10));
        palette.getContentPane().add((Component)p, "North");
        p = new JPanel(){
            Insets insets = new Insets(10, 15, 10, 5);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        p.setLayout(new GridLayout(2, 2));
        this.windowResizable = new JCheckBox("Resizeable", true);
        this.windowClosable = new JCheckBox("Closeable", true);
        this.windowIconifiable = new JCheckBox("Iconifiable", true);
        this.windowMaximizable = new JCheckBox("Maximizable", true);
        p.add(this.windowResizable);
        p.add(this.windowClosable);
        p.add(this.windowIconifiable);
        p.add(this.windowMaximizable);
        palette.getContentPane().add((Component)p, "Center");
        p = new JPanel(){
            Insets insets = new Insets(0, 0, 10, 0);

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.windowTitleField = new JTextField("Internal-Frame");
        this.windowTitleLabel = new JLabel("Title");
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createRigidArea(HGAP5));
        p.add((Component)this.windowTitleLabel, "West");
        p.add(Box.createRigidArea(HGAP5));
        p.add((Component)this.windowTitleField, "Center");
        p.add(Box.createRigidArea(HGAP5));
        palette.getContentPane().add((Component)p, "South");
        palette.show();
        return palette;
    }

    public int getFrameWidth() {
        return this.FRAME_WIDTH;
    }

    public int getFrameHeight() {
        return this.FRAME_HEIGHT;
    }

    public Integer getDemoFrameLayer() {
        return this.DEMO_FRAME_LAYER;
    }

    class ImageScroller
    extends JScrollPane {
        public ImageScroller(Icon icon, int layer, int count) {
            JPanel p = new JPanel();
            p.setBackground(Color.white);
            p.setLayout(new BorderLayout());
            p.add((Component)new JLabel(icon), "Center");
            this.getViewport().add(p);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(25, 25);
        }
    }

    class ShowFrameAction
    extends AbstractAction {
        InternalFramePanel ifPanel;
        Icon icon;

        public ShowFrameAction(InternalFramePanel ifPanel, Icon icon) {
            this.ifPanel = ifPanel;
            this.icon = icon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ifPanel.createInternalFrame(this.icon, InternalFramePanel.this.getDemoFrameLayer(), InternalFramePanel.this.getFrameWidth(), InternalFramePanel.this.getFrameHeight());
        }
    }
}

