/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.images.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private final String HELP_PATH = "/com/jtattoo/demo/resources/help/";
    private final String INDEX_PROPERTIES = "/com/jtattoo/demo/resources/help/index.properties";
    private final String HOME_PAGE = "/com/jtattoo/demo/resources/help/home.html";
    private ImageIcon prevIcon = null;
    private ImageIcon nextIcon = null;
    private ImageIcon homeIcon = null;
    private ImageIcon exitIcon = null;
    private JButton prevButton = null;
    private JButton nextButton = null;
    private JButton homeButton = null;
    private JButton exitButton = null;
    private JToolBar toolBar = null;
    private JTree indexTree = null;
    private JEditorPane helpPane = null;
    private Vector helpStack = null;
    private int helpStackIndex = 0;
    private boolean blockHelpStack = false;

    public HelpDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), "Help", true);
        this.init();
    }

    private void init() {
        this.helpStack = new Vector();
        this.helpStackIndex = 0;
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.initToolBar();
        this.initIndexTree();
        this.initHelpPane();
        JPanel indexPanel = new JPanel(new BorderLayout());
        indexPanel.add((Component)this.toolBar, "North");
        indexPanel.add((Component)new JScrollPane(this.indexTree), "Center");
        JSplitPane splitPane = new JSplitPane(1, true, indexPanel, new JScrollPane(this.helpPane));
        contentPanel.add((Component)splitPane, "Center");
        this.setContentPane(contentPanel);
        this.showDlg();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            try {
                pane.setPage(e.getURL());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void showDlg() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = new Dimension(840, 640);
        int dlgPosX = screenSize.width / 2 - dlgSize.width / 2;
        int dlgPosY = screenSize.height / 2 - dlgSize.height / 2;
        this.setLocation(dlgPosX, dlgPosY);
        this.setSize(dlgSize);
        this.show();
    }

    private void initToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.prevIcon = ImageHelper.loadImage("prev.gif");
        this.prevButton = new NoFocusButton(this.prevIcon);
        this.prevButton.setToolTipText("prev page");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelpDialog.this.helpStackIndex > 0) {
                    HelpDialog.this.blockHelpStack = true;
                    HelpDialog helpDialog = HelpDialog.this;
                    helpDialog.helpStackIndex = helpDialog.helpStackIndex - 1;
                    TreePath path = (TreePath)HelpDialog.this.helpStack.get(HelpDialog.this.helpStackIndex);
                    HelpDialog.this.indexTree.setSelectionPath(path);
                    HelpDialog.this.blockHelpStack = false;
                }
            }
        });
        this.nextIcon = ImageHelper.loadImage("next.gif");
        this.nextButton = new NoFocusButton(this.nextIcon);
        this.nextButton.setToolTipText("next page");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HelpDialog.this.helpStackIndex < HelpDialog.this.helpStack.size() - 1) {
                    HelpDialog.this.blockHelpStack = true;
                    HelpDialog helpDialog = HelpDialog.this;
                    helpDialog.helpStackIndex = helpDialog.helpStackIndex + 1;
                    TreePath path = (TreePath)HelpDialog.this.helpStack.get(HelpDialog.this.helpStackIndex);
                    HelpDialog.this.indexTree.setSelectionPath(path);
                    HelpDialog.this.blockHelpStack = false;
                }
            }
        });
        this.homeIcon = ImageHelper.loadImage("home.gif");
        this.homeButton = new NoFocusButton(this.homeIcon);
        this.homeButton.setToolTipText("home page");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.indexTree.setSelectionRow(0);
            }
        });
        this.exitIcon = ImageHelper.loadImage("exit.gif");
        this.exitButton = new NoFocusButton(this.exitIcon);
        this.exitButton.setToolTipText("quit help");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.dispose();
            }
        });
        this.toolBar.add(this.prevButton);
        this.toolBar.add(this.nextButton);
        this.toolBar.add(this.homeButton);
        this.toolBar.addSeparator(new Dimension(110, 8));
        this.toolBar.add(this.exitButton);
    }

    private void initIndexTree() {
        DefaultMutableTreeNode home = new DefaultMutableTreeNode(new TreeNodeData("Home", "home.html"));
        DefaultMutableTreeNode nodeI = null;
        try {
            URL url = this.getClass().getResource("/com/jtattoo/demo/resources/help/index.properties");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = null;
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.charAt(0) == '#') continue;
                int posCategory = s.indexOf(59);
                int posFileName = s.indexOf(61);
                String category = s.substring(0, posCategory);
                String displayString = s.substring(posCategory + 1, posFileName);
                String fileName = s.substring(posFileName + 1);
                if (category.equals("I")) {
                    nodeI = new DefaultMutableTreeNode(new TreeNodeData(displayString, fileName));
                    home.add(nodeI);
                    continue;
                }
                if (category.equals("P")) {
                    home.add(new DefaultMutableTreeNode(new TreeNodeData(displayString, fileName)));
                    continue;
                }
                if (!category.equals("IP")) continue;
                nodeI.add(new DefaultMutableTreeNode(new TreeNodeData(displayString, fileName)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.indexTree = new JTree(home);
        this.indexTree.getSelectionModel().setSelectionMode(1);
        this.indexTree.requestFocus();
        this.indexTree.setSelectionRow(0);
        this.helpStack.add(this.indexTree.getSelectionPath());
        this.updateHelpStack();
        this.indexTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selPath = HelpDialog.this.indexTree.getSelectionPath();
                if (selPath != null) {
                    DefaultMutableTreeNode selPage = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                    TreeNodeData nodeData = (TreeNodeData)selPage.getUserObject();
                    try {
                        HelpDialog.this.helpPane.setPage(this.getClass().getResource(nodeData.getURL()));
                        if (!HelpDialog.this.blockHelpStack) {
                            HelpDialog.this.helpStack.add(selPath);
                            HelpDialog.this.helpStackIndex = HelpDialog.this.helpStack.size() - 1;
                        }
                        HelpDialog.this.updateHelpStack();
                    }
                    catch (Exception ex) {
                        HelpDialog.this.helpPane.setText("<html><h2>ERROR: " + nodeData.getURL() + "</h2></html>");
                    }
                    HelpDialog.this.helpPane.validate();
                }
            }
        });
    }

    private void initHelpPane() {
        try {
            URL url = this.getClass().getResource("/com/jtattoo/demo/resources/help/home.html");
            this.helpPane = new JEditorPane(url){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2D = (Graphics2D)g;
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g);
                }
            };
            this.helpPane.setEditable(false);
            this.helpPane.addHyperlinkListener(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateHelpStack() {
        this.prevButton.setEnabled(this.helpStack.size() > 1 && this.helpStackIndex > 0);
        this.nextButton.setEnabled(this.helpStack.size() > 1 && this.helpStackIndex < this.helpStack.size() - 1);
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton(ImageIcon icon) {
            super(icon);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }
    }

    private class TreeNodeData {
        private String displayString = null;
        private String url = null;

        public TreeNodeData(String aDisplayString, String fileName) {
            this.displayString = aDisplayString;
            this.url = "/com/jtattoo/demo/resources/help/" + fileName;
        }

        public String getDisplayString() {
            return this.displayString;
        }

        public String getURL() {
            return this.url;
        }

        public String toString() {
            return this.displayString;
        }
    }
}

