/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.app.CustomDialogPanel;
import com.jtattoo.demo.app.JTattooDemo;
import com.jtattoo.demo.images.ImageHelper;
import com.jtattoo.demo.utils.GridBagHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogPanel
extends JPanel {
    private Component parent = null;
    private JButton informationButton = null;
    private JButton confirmationButton = null;
    private JButton warningButton = null;
    private JButton errorButton = null;
    private JButton optionButton = null;
    private JButton nativeFileChooserButton = null;
    private JButton fileChooserButton = null;
    private JButton colorChooserButton = null;
    private JButton customDialogButton = null;
    private FileDialog fileDialog = null;

    public DialogPanel(Component aParent) {
        super(new BorderLayout());
        this.parent = aParent;
        this.init();
    }

    private void init() {
        this.setName("Dialogs");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.informationButton = new JButton("Information dialog");
        this.informationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogPanel.this.parent, "Information dialog", "Information", 1);
            }
        });
        this.confirmationButton = new JButton("Confirmation dialog");
        this.confirmationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogPanel.this.parent, "Confirmation dialog", "Confirmation", 3);
            }
        });
        this.warningButton = new JButton("Warning dialog");
        this.warningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogPanel.this.parent, "Warning dialog", "Warning", 2);
            }
        });
        this.errorButton = new JButton("Error dialog");
        this.errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogPanel.this.parent, "Error dialog", "Error", 0);
            }
        });
        this.optionButton = new JButton("Option dialog");
        this.optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{"Yes", "No"};
                int confirm = JOptionPane.showOptionDialog(null, "Please select yes or no using the keyboard (tab/enter) keys\n", "Confirmation Required", 0, 3, null, options, options[1]);
                if (confirm == 0 || confirm == 1) {
                    DialogPanel.this.optionButton.setText("Option dialog. Selected: " + options[confirm]);
                } else {
                    DialogPanel.this.optionButton.setText("Option dialog. Selected: nothing ");
                }
            }
        });
        this.nativeFileChooserButton = new JButton("Native FileChooser dialog");
        this.nativeFileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPanel.this.fileDialog = new FileDialog(JOptionPane.getFrameForComponent(DialogPanel.this.parent), "Open File");
                DialogPanel.this.fileDialog.setResizable(true);
                DialogPanel.this.fileDialog.setVisible(true);
            }
        });
        this.fileChooserButton = new JButton("FileChooser dialog");
        this.fileChooserButton.setEnabled(!(this.parent instanceof JApplet));
        this.fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int result = fc.showOpenDialog(DialogPanel.this.parent);
            }
        });
        this.colorChooserButton = new JButton("ColorChooser dialog");
        this.colorChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(DialogPanel.this.parent, "JColorChooser", Color.blue);
            }
        });
        this.customDialogButton = new JButton("Custom dialog");
        this.customDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPanel.this.openCustomDialog();
            }
        });
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagHelper.addComponent(contentPanel, this.informationButton, 0, 0, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.confirmationButton, 0, 1, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.warningButton, 0, 2, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.errorButton, 0, 3, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.optionButton, 0, 4, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.nativeFileChooserButton, 0, 5, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.fileChooserButton, 0, 6, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.colorChooserButton, 0, 7, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(contentPanel, this.customDialogButton, 0, 8, 1, 1, 16, 8, 0, 4, 0.0, 0.0, 2, 10);
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
    }

    private void openCustomDialog() {
        JDialog dlg = new JDialog((Frame)JTattooDemo.app, "Custom dialog");
        dlg.setResizable(false);
        CustomDialogPanel panel = new CustomDialogPanel(dlg);
        dlg.setContentPane(panel);
        int x = JTattooDemo.app.getLocation().x + 200;
        int y = JTattooDemo.app.getLocation().y + 100;
        dlg.setBounds(x, y, 336, 240);
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            dlg.setIconImage(ImageHelper.loadImage("cab_small.gif").getImage());
        }
        dlg.setVisible(true);
    }
}

