/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.images.ImageHelper;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class CustomWindowTitleDemo
extends JFrame {
    private JTitleCheckBox checkBox = null;
    private JTitleButton button = null;
    private JTitleMenuButton menuButton = null;

    public CustomWindowTitleDemo() {
        super("CustomWindowTitleSample");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        JScrollPane westPanel = new JScrollPane(new JTree());
        JEditorPane editor = new JEditorPane("text/plain", "Hello World");
        JScrollPane eastPanel = new JScrollPane(editor);
        JSplitPane splitPane = new JSplitPane(1, true, westPanel, eastPanel);
        splitPane.setDividerLocation(148);
        contentPanel.add((Component)splitPane, "Center");
        this.setContentPane(contentPanel);
        this.checkBox = new JTitleCheckBox("Check");
        this.button = new JTitleButton("Button");
        this.menuButton = new JTitleMenuButton("Menu");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomWindowTitleDemo.this, "CheckBox clicked");
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CustomWindowTitleDemo.this, "Button clicked");
            }
        });
        this.setLocation(32, 32);
        this.setSize(800, 600);
        this.setVisible(true);
    }

    public void customizeTitlePanel() {
        if (this.getRootPane().getUI() instanceof BaseRootPaneUI) {
            BaseRootPaneUI rootPaneUI = (BaseRootPaneUI)this.getRootPane().getUI();
            TitlePaneLayout layout = new TitlePaneLayout();
            JPanel panel = new JPanel(layout);
            panel.setOpaque(false);
            panel.add(this.checkBox);
            panel.add(this.button);
            panel.add(this.menuButton);
            BaseTitlePane tp = rootPaneUI.getTitlePane();
            tp.setCustomizedTitlePanel(panel);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.graphite.GraphiteLookAndFeel");
            CustomWindowTitleDemo frame = new CustomWindowTitleDemo();
            frame.customizeTitlePanel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class JTitleButton
    extends JButton {
        public JTitleButton(String title) {
            super(title);
            this.setFocusable(false);
        }
    }

    public class JTitleCheckBox
    extends JCheckBox {
        public JTitleCheckBox(String title) {
            super(title);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setOpaque(false);
            this.setFocusable(false);
        }
    }

    public class JTitleMenuButton
    extends JButton {
        public JTitleMenuButton(String title) {
            super(title, ImageHelper.loadImage("DownArrow.gif"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setForeground(UIManager.getColor("activeCaptionText"));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JTitleMenuButton.this.setForeground(Color.black);
                    JTitleMenuButton.this.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JTitleMenuButton.this.setForeground(UIManager.getColor("activeCaptionText"));
                    JTitleMenuButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTitleMenuButton.this.showPopup();
                }
            });
        }

        private void showPopup() {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Menu #1");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomWindowTitleDemo.this, "Menu #1 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #2");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomWindowTitleDemo.this, "Menu #2 clicked");
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Menu #3");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(CustomWindowTitleDemo.this, "Menu #3 clicked");
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this, 0, this.getHeight() - 1);
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = 0;
            int count = parent.getComponentCount();
            int[] w = new int[count];
            int i = 0;
            while (i < count) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    w[i] = c.getPreferredSize().width;
                    width += w[i];
                    width += 4;
                }
                ++i;
            }
            int x = parent.getWidth() - width;
            if (!parent.getComponentOrientation().isLeftToRight()) {
                x = 0;
            }
            int y = 0;
            int h = parent.getHeight() - 2;
            int i2 = 0;
            while (i2 < count) {
                Component c = parent.getComponent(i2);
                if (c.isVisible()) {
                    c.setBounds(x, y, w[i2], h);
                    x += w[i2] + 4;
                }
                ++i2;
            }
        }
    }
}

