/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.demo.app;

import com.jtattoo.demo.app.SplashPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AboutDialog
extends JDialog {
    private Component parent = null;

    public AboutDialog(Component aParent) {
        super(JOptionPane.getFrameForComponent(aParent), "About", true);
        this.parent = aParent;
        this.init();
    }

    private void init() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel aboutPanel = new JPanel();
        aboutPanel.setBorder(BorderFactory.createEmptyBorder(32, 8, 8, 8));
        SplashPanel splashPanel = new SplashPanel();
        aboutPanel.add(splashPanel);
        tabbedPane.add("About", aboutPanel);
        if (!(this.parent instanceof JApplet)) {
            JPanel propertiesPanel = new JPanel(new BorderLayout());
            JTable propertiesTable = new JTable(new PropertiesTableModel());
            propertiesTable.setAutoResizeMode(0);
            propertiesTable.setColumnSelectionAllowed(false);
            propertiesTable.setRowSelectionAllowed(false);
            propertiesTable.getColumnModel().getColumn(0).setPreferredWidth(188);
            propertiesTable.getColumnModel().getColumn(1).setPreferredWidth(418);
            propertiesPanel.add((Component)new JScrollPane(propertiesTable), "Center");
            tabbedPane.add("Properties", propertiesPanel);
        }
        contentPanel.add((Component)tabbedPane, "Center");
        this.setContentPane(contentPanel);
        this.showDlg();
    }

    private void showDlg() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = new Dimension(640, 480);
        int dlgPosX = screenSize.width / 2 - dlgSize.width / 2;
        int dlgPosY = screenSize.height / 2 - dlgSize.height / 2;
        this.setLocation(dlgPosX, dlgPosY);
        this.setSize(dlgSize);
        this.setVisible(true);
    }

    private class PropertiesTableModel
    extends AbstractTableModel {
        private PropertiesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            if (index == 0) {
                return "Property";
            }
            if (index == 1) {
                return "Value";
            }
            return "ERROR";
        }

        @Override
        public int getRowCount() {
            return System.getProperties().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            Iterator<Object> iter = System.getProperties().keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object key = iter.next();
                if (i == rowIndex) {
                    if (colIndex == 0) {
                        return key;
                    }
                    return System.getProperties().getProperty(key.toString());
                }
                ++i;
            }
            return "ERROR";
        }
    }
}

