/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.border;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JTBorderFactory {
    private JTBorderFactory() {
    }

    public static Border createTitleBorder(Icon icon) {
        return new TitleBorder(icon, "", 3, 4);
    }

    public static Border createTitleBorder(String title) {
        return new TitleBorder(null, title, 3, 4);
    }

    public static Border createTitleBorder(Icon icon, String title) {
        return new TitleBorder(icon, title, 3, 4);
    }

    public static Border createTitleBorder(Icon icon, String title, int shadowSize) {
        return new TitleBorder(icon, title, Math.max(Math.min(shadowSize, 32), 0), 4);
    }

    public static Border createTitleBorder(Icon icon, String title, int shadowSize, int innerSpace) {
        return new TitleBorder(icon, title, Math.max(Math.min(shadowSize, 32), 0), Math.max(Math.min(innerSpace, 32), 0));
    }

    public static class TitleBorder
    extends AbstractBorder {
        private Icon icon = null;
        private String title = null;
        private int shadowSize = 3;
        private int innerSpace = 4;

        public TitleBorder(Icon aIcon, String aTitle, int aShadowSize, int aInnerSpace) {
            this.icon = aIcon;
            this.title = aTitle;
            this.shadowSize = aShadowSize;
            this.innerSpace = aInnerSpace;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            Composite composite = g2D.getComposite();
            Color hiFrameColor = null;
            Color loFrameColor = null;
            Color hiBackColor = null;
            Color loBackColor = null;
            Color textColor = null;
            if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                hiFrameColor = AbstractLookAndFeel.getControlHighlight();
                loFrameColor = AbstractLookAndFeel.getControlShadow();
                hiBackColor = ColorHelper.brighter(AbstractLookAndFeel.getBackgroundColor(), 20.0);
                loBackColor = ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 5.0);
                textColor = AbstractLookAndFeel.getForegroundColor();
            } else {
                hiFrameColor = Color.white;
                loFrameColor = Color.gray;
                hiBackColor = ColorHelper.brighter(c.getBackground(), 30.0);
                loBackColor = ColorHelper.darker(c.getBackground(), 10.0);
                textColor = c.getForeground();
            }
            int titleHeight = this.getBorderInsets((Component)c).top - 3 - this.innerSpace;
            g.setColor(loFrameColor);
            g.drawRect(x, y, w - this.shadowSize - 1, h - this.shadowSize - 1);
            g.setColor(hiFrameColor);
            g.drawRect(x + 1, y + 1, w - this.shadowSize - 3, h - this.shadowSize - 3);
            g.setColor(loFrameColor);
            g.drawLine(x + 2, y + this.getBorderInsets((Component)c).top - this.innerSpace - 1, x + w - this.shadowSize - 3, y + this.getBorderInsets((Component)c).top - this.innerSpace - 1);
            if (this.shadowSize > 0) {
                g2D.setColor(new Color(0, 16, 0));
                float alphaValue = 0.4f;
                int i = 0;
                while (i < this.shadowSize) {
                    AlphaComposite alpha = AlphaComposite.getInstance(3, alphaValue);
                    g2D.setComposite(alpha);
                    g.drawLine(x + w - this.shadowSize + i, y + this.shadowSize + 4, x + w - this.shadowSize + i, y + h - this.shadowSize - 1 + i);
                    g.drawLine(x + this.shadowSize + 2, y + h - this.shadowSize + i, x + w - this.shadowSize + i, y + h - this.shadowSize + i);
                    alphaValue -= alphaValue / 2.0f;
                    ++i;
                }
            }
            g2D.setComposite(composite);
            Color[] colors = ColorHelper.createColorArr(hiBackColor, loBackColor, 48);
            JTattooUtilities.fillVerGradient(g, colors, x + 2, y + 2, w - this.shadowSize - 4, titleHeight);
            this.paintText(c, g, x, y, w, h, textColor, null);
        }

        private void paintText(Component c, Graphics g, int x, int y, int w, int h, Color textColor, Color shadowColor) {
            boolean leftToRight = JTattooUtilities.isLeftToRight(c);
            int sw = w - 8 - 2 * this.innerSpace;
            x = leftToRight ? (x += 4 + this.innerSpace) : w - 4 - this.innerSpace;
            int titleHeight = this.getBorderInsets((Component)c).top - 3 - this.innerSpace;
            if (this.icon != null) {
                int yc = y + 2 + (titleHeight - this.icon.getIconHeight()) / 2;
                if (leftToRight) {
                    this.icon.paintIcon(c, g, x, yc);
                    x += this.icon.getIconWidth() + 4;
                } else {
                    this.icon.paintIcon(c, g, x - this.icon.getIconWidth(), yc);
                    x -= this.icon.getIconWidth() + 4;
                }
                sw -= this.icon.getIconWidth();
            }
            if (this.title != null && this.title.trim().length() > 0) {
                g.setFont(c.getFont());
                FontMetrics fm = g.getFontMetrics();
                String theTitle = JTattooUtilities.getClippedText(this.title, fm, sw);
                if (!leftToRight) {
                    x = (int)((double)x - fm.getStringBounds(theTitle, g).getWidth());
                }
                y += fm.getHeight();
                if (shadowColor != null) {
                    g.setColor(shadowColor);
                    g.drawString(theTitle, x + 1, y + 1);
                }
                g.setColor(textColor);
                if (c instanceof JComponent) {
                    JTattooUtilities.drawString((JComponent)c, g, theTitle, x, y);
                } else {
                    g.drawString(theTitle, x, y);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Graphics g = c.getGraphics();
            if (g != null) {
                FontMetrics fm = g.getFontMetrics(c.getFont());
                int frameWidth = 2 + this.innerSpace;
                int titleHeight = fm.getHeight() + fm.getHeight() / 4;
                if (this.icon != null) {
                    titleHeight = Math.max(titleHeight, this.icon.getIconHeight() + this.icon.getIconHeight() / 4);
                }
                return new Insets(titleHeight + frameWidth, frameWidth, frameWidth + this.shadowSize, frameWidth + this.shadowSize);
            }
            return new Insets(0, 0, 0, 0);
        }
    }
}

