/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.CastorDataAdapterPersistenceService;
import net.sf.jasperreports.repo.CastorObjectPersistenceService;
import net.sf.jasperreports.repo.CastorResource;
import net.sf.jasperreports.repo.DataAdapterResource;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.InputStreamPersistenceService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.OutputStreamPersistenceService;
import net.sf.jasperreports.repo.OutputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.ResourceBundlePersistenceService;
import net.sf.jasperreports.repo.ResourceBundleResource;
import net.sf.jasperreports.repo.SerializableResource;
import net.sf.jasperreports.repo.SerializedObjectPersistenceService;
import net.sf.jasperreports.repo.SerializedReportPersistenceService;

public class FileRepositoryPersistenceServiceFactory
implements PersistenceServiceFactory {
    private static final FileRepositoryPersistenceServiceFactory INSTANCE = new FileRepositoryPersistenceServiceFactory();

    public static FileRepositoryPersistenceServiceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <K extends RepositoryService, L extends Resource> PersistenceService getPersistenceService(JasperReportsContext jasperReportsContext, Class<K> repositoryServiceType, Class<L> resourceType) {
        if (FileRepositoryService.class.isAssignableFrom(repositoryServiceType)) {
            if (InputStreamResource.class.getName().equals(resourceType.getName())) {
                return new InputStreamPersistenceService();
            }
            if (OutputStreamResource.class.getName().equals(resourceType.getName())) {
                return new OutputStreamPersistenceService();
            }
            if (ReportResource.class.getName().equals(resourceType.getName())) {
                return new SerializedReportPersistenceService();
            }
            if (ResourceBundleResource.class.getName().equals(resourceType.getName())) {
                return new ResourceBundlePersistenceService(jasperReportsContext);
            }
            if (DataAdapterResource.class.isAssignableFrom(resourceType)) {
                return new CastorDataAdapterPersistenceService(jasperReportsContext);
            }
            if (CastorResource.class.isAssignableFrom(resourceType)) {
                return new CastorObjectPersistenceService(jasperReportsContext);
            }
            if (SerializableResource.class.isAssignableFrom(resourceType)) {
                return new SerializedObjectPersistenceService();
            }
        }
        return null;
    }
}

