/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.PrintElementVisitor;

public class CompositePrintElementVisitor<T>
implements PrintElementVisitor<T> {
    private final PrintElementVisitor<T>[] visitors;

    public CompositePrintElementVisitor(PrintElementVisitor<T> ... visitors) {
        this.visitors = visitors;
    }

    @Override
    public void visit(JRPrintText textElement, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(textElement, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRPrintImage image, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(image, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRPrintRectangle rectangle, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(rectangle, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRPrintLine line, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(line, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRPrintEllipse ellipse, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(ellipse, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRPrintFrame frame, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(frame, arg);
            ++n2;
        }
    }

    @Override
    public void visit(JRGenericPrintElement printElement, T arg) {
        PrintElementVisitor<T>[] printElementVisitorArray = this.visitors;
        int n = this.visitors.length;
        int n2 = 0;
        while (n2 < n) {
            PrintElementVisitor<T> visitor = printElementVisitorArray[n2];
            visitor.visit(printElement, arg);
            ++n2;
        }
    }
}

