/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.json;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonDataSource;

public class JsonDataAdapterService
extends AbstractDataAdapterService {
    public JsonDataAdapterService(JasperReportsContext jasperReportsContext, JsonDataAdapter jsonDataAdapter) {
        super(jasperReportsContext, jsonDataAdapter);
    }

    public JsonDataAdapterService(JsonDataAdapter jsonDataAdapter) {
        super(DefaultJasperReportsContext.getInstance(), jsonDataAdapter);
    }

    public JsonDataAdapter getJsonDataAdapter() {
        return (JsonDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JsonDataAdapter jsonDataAdapter = this.getJsonDataAdapter();
        if (jsonDataAdapter != null) {
            if (jsonDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                parameters.put("net.sf.jasperreports.json.source", jsonDataAdapter.getFileName());
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("JSON_LOCALE", locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    parameters.put("JSON_TIME_ZONE", timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.date.pattern", datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("net.sf.jasperreports.json.number.pattern", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JsonDataSource ds = new JsonDataSource(this.getJasperReportsContext(), jsonDataAdapter.getFileName(), jsonDataAdapter.getSelectExpression());
                Locale locale = jsonDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = jsonDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = jsonDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = jsonDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }
}

