/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.trading.model;

import eqtrade.trading.core.r;
import eqtrade.trading.model.Model;
import org.json.simple.JSONObject;
import quickfix.Message;

public class TradingLimit
extends Model {
    public static final int C_ID = 0;
    public static final int C_BROKER = 1;
    public static final int C_CURRENCY = 2;
    public static final int C_OPENBAL = 3;
    public static final int C_CURRENTPOS = 4;
    public static final int C_PLANNEDPOS = 5;
    public static final int C_LIMIT1 = 6;
    public static final int C_LIMIT1SET = 7;
    public static final int C_LIMIT2 = 8;
    public static final int C_LIMIT2SET = 9;
    public static final int C_DESCRIPTION = 10;
    public static final int C_TAG = 11;
    public static final int CIDN_NUMBEROFFIELDS = 12;

    public TradingLimit(Message message) {
        this();
        try {
            String string = message.getString(76);
            String string2 = message.getString(15);
            Double d2 = message.getDouble(6056);
            Double d3 = message.getDouble(6057);
            Double d4 = message.getDouble(6058);
            Double d5 = message.getDouble(6059);
            String string3 = message.getString(6060);
            Double d6 = message.getDouble(6061);
            String string4 = message.getString(6062);
            this.setBrokerID(string);
            this.setCurrency(string2);
            this.setCurrentPos(d3);
            this.setLimit1(d5);
            this.setLimit1Set(string3);
            this.setLimit2(d6);
            this.setLimit2Set(string4);
            this.setOpenBal(d2);
            this.setPlannedPos(d4);
            this.setID(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TradingLimit(JSONObject jSONObject) {
        this();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get("id");
        this.setBrokerID(jSONObject2.get("execbroker").toString());
        this.setID(((Double)jSONObject2.get("recnum")).intValue());
        this.setOpenBal((Double)jSONObject.get("openbal"));
        this.setCurrency(jSONObject.get("currencyid").toString());
        this.setLimit2Set(jSONObject.get("limit2set").toString());
        this.setCurrentPos((Double)jSONObject.get("currentpos"));
        this.setData(jSONObject.get("description").toString(), 10);
        this.setData(jSONObject.get("tag").toString(), 11);
        this.setLimit2((Double)jSONObject.get("limit2"));
        this.setLimit1((Double)jSONObject.get("limit1"));
        this.setLimit1Set(jSONObject.get("limit1set").toString());
        this.setPlannedPos((Double)jSONObject.get("plannepos"));
    }

    public void setID(Integer n2) {
        this.setData(n2, 0);
    }

    public void setBrokerID(String string) {
        this.setData(string, 1);
    }

    public void setCurrency(String string) {
        this.setData(string, 2);
    }

    public void setOpenBal(Double d2) {
        this.setData(d2, 3);
    }

    public void setCurrentPos(Double d2) {
        this.setData(d2, 4);
    }

    public void setPlannedPos(Double d2) {
        this.setData(d2, 5);
    }

    public void setLimit1(Double d2) {
        this.setData(d2, 6);
    }

    public void setLimit1Set(String string) {
        this.setData(string, 7);
    }

    public void setLimit2(Double d2) {
        this.setData(d2, 8);
    }

    public void setLimit2Set(String string) {
        this.setData(string, 9);
    }

    public TradingLimit() {
        super(12);
    }

    @Override
    protected void convertType() {
        block3: for (int i2 = 0; i2 < 12; ++i2) {
            switch (i2) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    this.vdata.setElementAt(new Double(r.a((String)this.vdata.elementAt(i2), 0.0)), i2);
                    continue block3;
                }
            }
        }
    }

    public Integer getID() {
        return (Integer)this.getData(0);
    }

    public String getBrokerID() {
        return (String)this.getData(1);
    }

    public String getCurrency() {
        return (String)this.getData(2);
    }

    public Double getOpenBal() {
        return (Double)this.getData(3);
    }

    public Double getCurrentPos() {
        return (Double)this.getData(4);
    }

    public Double getPlannedPos() {
        return (Double)this.getData(5);
    }

    public Double getLimit1() {
        return (Double)this.getData(6);
    }

    public String getLimit1Set() {
        return (String)this.getData(7);
    }

    public Double getLimit2() {
        return (Double)this.getData(8);
    }

    public String getLimit2Set() {
        return (String)this.getData(9);
    }

    public String toString() {
        return this.getBrokerID() + ":" + this.getOpenBal() + ":" + this.getPlannedPos();
    }
}

