/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.trading.model;

import com.eqtrade.ux.d.J;
import eqtrade.trading.core.r;

public class PortfolioSimple
extends J {
    public static final int C_TRADINGID = 0;
    public static final int C_ACCID = 1;
    public static final int C_ACCNAME = 2;
    public static final int C_INVTYPE = 3;
    public static final int C_CURRVOLUME = 4;
    public static final int C_CURRLOT = 5;
    public static final int C_AVAILABLEVOLUME = 6;
    public static final int C_MARKETPRICE = 7;
    public static final int C_STOCKVALUE = 8;
    public static final int C_AVGPRICE = 9;
    public static final int C_PLPERCENT = 10;
    public static final int C_PLVALUE = 11;
    public static final int C_SECID = 12;
    public static final int C_PREV = 13;
    public static final int C_ACCTYPE = 14;
    public static final int CIDN_NUMBEROFFIELDS = 15;
    private String tradingId = "";
    private String accName = "";
    private String custId = "";
    private String invType = "";
    private Double currVolume = 0.0;
    private Double availableVolume = 0.0;
    private Double marketPrice = 0.0;
    private Double stockValue = 0.0;
    private Double avgPrice = 0.0;
    private Double plPercent = 0.0;
    private Double plValue = 0.0;
    private String secid = "";
    private Double totalQty = 0.0;
    private Double currLot = 0.0;
    private Double prev = 0.0;
    private String acctype = "";

    public PortfolioSimple(String[] stringArray) {
        this.accName = stringArray[0];
        this.invType = stringArray[1];
        this.tradingId = stringArray[2];
        this.custId = stringArray[2];
        this.secid = stringArray[3];
        this.availableVolume = r.a(stringArray[4], 0.0);
        this.currVolume = r.a(stringArray[5], 0.0);
        this.currLot = this.currVolume > 0.0 ? Math.floor(this.currVolume / 100.0) : 0.0;
        this.marketPrice = r.a(stringArray[6], 0.0);
        this.stockValue = r.a(stringArray[7], 0.0);
        this.avgPrice = r.a(stringArray[8], 0.0);
        double d2 = r.a(stringArray[9], 0.0);
        double d3 = r.a(stringArray[10], 0.0) - r.a(stringArray[11], 0.0);
        this.totalQty = this.currVolume;
        this.prev = 0.0;
        this.acctype = "";
        this.calculate();
    }

    public void calculate() {
        double d2 = this.totalQty * this.marketPrice;
        if (this.totalQty > 0.0) {
            this.plValue = d2 - this.stockValue;
            this.plPercent = this.stockValue > 0.0 ? Double.valueOf(this.plValue * 100.0 / this.stockValue) : Double.valueOf(0.0);
        } else {
            this.plValue = 0.0;
            this.plPercent = 0.0;
        }
    }

    @Override
    public Object getData(int n2) {
        switch (n2) {
            case 0: {
                return this.tradingId;
            }
            case 1: {
                return this.custId;
            }
            case 2: {
                return this.accName;
            }
            case 3: {
                return this.invType;
            }
            case 4: {
                return this.currVolume;
            }
            case 5: {
                return this.currLot;
            }
            case 6: {
                return this.availableVolume;
            }
            case 7: {
                return this.marketPrice;
            }
            case 8: {
                return this.stockValue;
            }
            case 9: {
                return this.avgPrice;
            }
            case 10: {
                return this.plPercent;
            }
            case 11: {
                return this.plValue;
            }
            case 12: {
                return this.secid;
            }
            case 13: {
                return this.prev;
            }
            case 14: {
                return this.acctype;
            }
        }
        return null;
    }

    @Override
    public void setData(Object object, int n2) {
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    public String getTradingId() {
        return this.tradingId;
    }

    public void setTradingId(String string) {
        this.tradingId = string;
    }

    public String getAccName() {
        return this.accName;
    }

    public void setAccName(String string) {
        this.accName = string;
    }

    public String getInvType() {
        return this.invType;
    }

    public void setInvType(String string) {
        this.invType = string;
    }

    public Double getCurrVolume() {
        return this.currVolume;
    }

    public void setCurrVolume(Double d2) {
        this.currVolume = d2;
    }

    public Double getAvailableVolume() {
        return this.availableVolume;
    }

    public void setAvailableVolume(Double d2) {
        this.availableVolume = d2;
    }

    public Double getMarketPrice() {
        return this.marketPrice;
    }

    public void setMarketPrice(Double d2) {
        this.marketPrice = d2;
    }

    public Double getStockValue() {
        return this.stockValue;
    }

    public void setStockValue(Double d2) {
        this.stockValue = d2;
    }

    public Double getAvgPrice() {
        return this.avgPrice;
    }

    public void setAvgPrice(Double d2) {
        this.avgPrice = d2;
    }

    public String getCustId() {
        return this.custId;
    }

    public void setCustId(String string) {
        this.custId = string;
    }

    public Double getPlPercent() {
        return this.plPercent;
    }

    public void setPlPercent(Double d2) {
        this.plPercent = d2;
    }

    public Double getPlValue() {
        return this.plValue;
    }

    public void setPlValue(Double d2) {
        this.plValue = d2;
    }

    public String getSecid() {
        return this.secid;
    }

    public void setSecid(String string) {
        this.secid = string;
    }

    public Double getTotalQty() {
        return this.totalQty;
    }

    public void setTotalQty456(Double d2) {
        this.totalQty = d2;
    }

    public Double getCurrLot() {
        return this.currLot;
    }

    public void setCurrLot(Double d2) {
        this.currLot = d2;
    }

    public Double getPrev() {
        return this.prev;
    }

    public void setPrev(Double d2) {
        this.prev = d2;
    }

    public String getAcctype() {
        return this.acctype;
    }

    public void setAcctype(String string) {
        this.acctype = string;
    }
}

