/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.trading.model;

import eqtrade.feed.model.bP;
import eqtrade.trading.core.r;
import eqtrade.trading.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Portfolio
extends Model {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 309177931626178221L;
    public static final int C_TRADINGID = 0;
    public static final int C_STOCK = 1;
    public static final int C_BEGVOLUME = 2;
    public static final int C_AVAILABLEVOLUME = 3;
    public static final int C_STOCKVAL = 4;
    public static final int C_AVGPRICE = 5;
    public static final int C_CLOSINGPRICE = 6;
    public static final int C_MYACC = 7;
    public static final int C_ACCOUNTID = 8;
    public static final int C_CURRVOLUME = 9;
    public static final int C_LASTPRICE = 10;
    public static final int C_LOTSIZE = 11;
    public static final int C_VALUELASTPRICE = 12;
    public static final int C_BEGLOT = 13;
    public static final int C_AVAILABLELOT = 14;
    public static final int C_CURRLOT = 15;
    public static final int C_PL = 16;
    public static final int C_PLPERCENT = 17;
    public static final int C_ONHANDVOL = 18;
    public static final int C_ONHANDLOT = 19;
    public static final int C_OUTBUY = 20;
    public static final int C_OUTSELL = 21;
    public static final int C_STOCKTYPE = 22;
    public static final int C_DONE_QTY = 23;
    public static final int C_GROSS_VALUE = 24;
    public static final int C_VAL_PERCENT = 25;
    public static final int C_MARKET_VAL_RA = 26;
    public static final int C_OPEN_BUY_VOL = 27;
    public static final int C_OPEN_SELL_QTY = 28;
    public static final int C_BEG_LOT = 29;
    public static final int C_DONE_LOT = 30;
    public static final int C_TOTAL_LOT = 31;
    public static final int C_TECHNICAL_TREND = 32;
    public static final int C_TOTAL_QTY = 33;
    public static final int C_DONE_BUY_VAL = 34;
    public static final int C_DONE_SELL_VAL = 35;
    public static final int C_INFO = 36;
    public static final int CIDN_NUMBEROFFIELDS = 37;
    private boolean isStockListed = true;

    public Portfolio() {
        super(37);
    }

    public Portfolio(boolean bl2) {
        super(37, bl2);
    }

    public Portfolio(String string) {
        super(37, string);
    }

    public Portfolio(String[] stringArray) {
        super(37);
    }

    @Override
    protected void convertType() {
        block3: for (int i2 = 0; i2 < 37; ++i2) {
            switch (i2) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 33: {
                    this.vdata.setElementAt(new Double(r.a((String)this.vdata.elementAt(i2), 0.0)), i2);
                    continue block3;
                }
            }
        }
        this.calculate();
    }

    public void calculate() {
        this.calculatePrice();
        this.calculateLot();
    }

    private void calculatePrice() {
        double d2 = this.getLotSize();
        double d3 = this.getLastPrice();
        this.setData(this.getCurrVolume(), 33);
        this.setValueLastPrice(new Double(this.getTotalQty() * d3));
        if (this.isStockListed) {
            if (this.getTotalQty() > 0.0) {
                this.setPLValue(new Double(this.getValueLastPrice() - this.getStockVal()));
                if (this.getStockVal() > 0.0) {
                    this.setPLPercent(new Double(this.getPLValue() * 100.0 / this.getStockVal()));
                } else {
                    this.setPLPercent(0.0);
                }
            } else {
                this.setPLValue(0.0);
                this.setPLPercent(0.0);
            }
        } else {
            this.setPLValue(0.0);
            this.setPLPercent(0.0);
        }
        this.setData(Math.floor(this.getBegVolume() / d2), 29);
        this.setData(this.getValueLastPrice() * this.getValPercent() / 100.0, 26);
        this.setGrossValue(this.getTotalQty() * this.getAvgPrice());
    }

    private void calculateLot() {
        double d2 = this.getLotSize();
        this.setBegLot(new Double(Math.floor(this.getBegVolume() / d2)));
        this.setCurrLot(new Double(Math.floor(this.getCurrVolume() / d2)));
        this.setAvailableLot(new Double(Math.floor(this.getAvailableVolume() / d2)));
        if (this.getOnHandLot() != null) {
            this.setOnHandLot(new Double(Math.floor(this.getOnHandVol() / d2)));
        }
        this.setData(new Double(Math.floor(this.getTotalQty() / d2)), 31);
    }

    public Double getTotalLot() {
        return (Double)this.getData(31);
    }

    public boolean isMyAccount() {
        return (Double)this.getData(7) == 1.0;
    }

    public void setMyAccount(boolean bl2) {
        this.setData(new Double(bl2 ? "1" : "0"), 7);
    }

    public String getAccountId() {
        return (String)this.getData(8);
    }

    public void setAccountId(String string) {
        this.setData(string, 8);
    }

    public String getTradingId() {
        return (String)this.getData(0);
    }

    public void setTradingId(String string) {
        this.setData(string, 0);
    }

    public String getStock() {
        return (String)this.getData(1);
    }

    public void setStock(String string) {
        this.setData(string, 1);
    }

    public Double getBegVolume() {
        return (Double)this.getData(2);
    }

    public void setBegVolume(Double d2) {
        this.setData(d2, 2);
    }

    public Double getAvailableVolume() {
        return (Double)this.getData(3);
    }

    public void setAvailableVolume(Double d2) {
        this.setData(d2, 3);
        this.calculate();
    }

    public Double getCurrVolume() {
        return (Double)this.getData(9);
    }

    public void setCurrVolume(Double d2) {
        this.setData(d2, 9);
        this.calculate();
    }

    public Double getStockVal() {
        return (Double)this.getData(4);
    }

    public void setStockVal(Double d2) {
        this.setData(d2, 4);
    }

    public Double getClosingPrice() {
        return (Double)this.getData(6);
    }

    public void setClosingPrice(Double d2) {
        this.setData(d2, 6);
        this.calculate();
    }

    public Double getLastPrice() {
        return (Double)this.getData(10);
    }

    public void setLastPrice(Double d2) {
        this.setData(d2, 10);
        this.calculate();
    }

    public Double getBegLot() {
        return (Double)this.getData(13);
    }

    public void setBegLot(Double d2) {
        this.setData(d2, 13);
    }

    public Double getAvailbaleLot() {
        return (Double)this.getData(14);
    }

    public void setAvailableLot(Double d2) {
        this.setData(d2, 14);
    }

    public Double getCurrLot() {
        return (Double)this.getData(15);
    }

    public void setCurrLot(Double d2) {
        this.setData(d2, 15);
    }

    public Double getPLPercent() {
        return (Double)this.getData(17);
    }

    public void setPLPercent(Double d2) {
        this.setData(d2, 17);
    }

    public Double getPLValue() {
        return (Double)this.getData(16);
    }

    public void setPLValue(Double d2) {
        this.setData(d2, 16);
    }

    public Double getValueLastPrice() {
        return (Double)this.getData(12);
    }

    public void setValueLastPrice(Double d2) {
        this.setData(d2, 12);
    }

    public Double getAvgPrice() {
        return (Double)this.getData(5);
    }

    public void setAvgPrice(Double d2) {
        this.setData(d2, 5);
    }

    public Double getOnHandVol() {
        Double d2 = (Double)this.getData(18);
        return d2;
    }

    public void setOnHandVol(Double d2) {
        this.setData(d2, 18);
    }

    public Double getOnHandLot() {
        return (Double)this.getData(19);
    }

    public void setOnHandLot(Double d2) {
        this.setData(d2, 19);
    }

    public Double getLotSize() {
        return (Double)this.getData(11);
    }

    public void setLotSize(Double d2) {
        this.setData(d2, 11);
        this.calculate();
    }

    public void setOutBuy(Double d2) {
        this.setData(d2, 20);
    }

    public Double getOutBuy() {
        return (Double)this.getData(20);
    }

    public void setOutSell(Double d2) {
        this.setData(d2, 21);
    }

    public Double getOutSell() {
        return (Double)this.getData(21);
    }

    public String getStockType() {
        return (String)this.getData(22);
    }

    public void setStockType(String string) {
        this.setData(string, 22);
    }

    public void setGrossValue(Double d2) {
        this.setData(d2, 24);
    }

    public Double getGrossValue() {
        return (Double)this.getData(24);
    }

    public void setValPercent(Double d2) {
        this.setData(d2, 25);
    }

    public Double getValPercent() {
        return (Double)this.getData(25);
    }

    public void setOpenSellVol(Double d2) {
        this.setData(d2, 28);
    }

    public Double getOpenSellVol() {
        return (Double)this.getData(28);
    }

    public void setOpenBuyVol(Double d2) {
        this.setData(d2, 27);
    }

    public Double getOpenBuyVol() {
        return (Double)this.getData(27);
    }

    public void setDoneVol(Double d2) {
        this.setData(d2, 23);
        this.setDoneLot(Math.floor(d2 / (double)r.c.intValue()));
    }

    public Double getDoneVol() {
        return (Double)this.getData(23);
    }

    public void setDoneLot(Double d2) {
        this.setData(d2, 30);
    }

    public Double getDoneLot() {
        return (Double)this.getData(30);
    }

    public boolean isStockListed() {
        return this.isStockListed;
    }

    public void setStockListed(boolean bl2) {
        this.isStockListed = bl2;
    }

    public void setMarketValRA(Double d2) {
        this.setData(d2, 26);
    }

    public Double getMarketValRA() {
        return (Double)this.getData(26);
    }

    public void setTotalQty456(Double d2) {
        this.setData(d2, 33);
    }

    public Double getTotalQty() {
        return (Double)this.getData(33);
    }

    public void setDoneBuyVal(Double d2) {
        this.setData(d2, 34);
    }

    public Double getDoneBuyVal() {
        return (Double)this.getData(34);
    }

    public void setDoneSellVal(Double d2) {
        this.setData(d2, 35);
    }

    public Double getDoneSellVal() {
        return (Double)this.getData(35);
    }

    public void setTrend(String string) {
        this.setData(string, 32);
    }

    public String getTrend() {
        return (String)this.getData(32);
    }

    public void setInfo(String string) {
        this.setData(string, 36);
    }

    public String getInfo() {
        return bP.h(this.getStock());
    }
}

