/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.trading.model;

import com.eqtrade.ux.d.L;
import eqtrade.trading.core.r;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public final class Order
extends L
implements Cloneable {
    public static final int C_ORDERID = 0;
    public static final int C_ORDERDATE = 1;
    public static final int C_XCHID = 2;
    public static final int C_BRDID = 3;
    public static final int C_BROKERID = 4;
    public static final int C_BUYORSELL = 5;
    public static final int C_ORDTYPE = 6;
    public static final int C_ORDERTYPE = 7;
    public static final int C_SECID = 8;
    public static final int C_ISADVERTISING = 9;
    public static final int C_TRADINGID = 10;
    public static final int C_INVTYPE = 11;
    public static final int C_CURID = 12;
    public static final int C_CONTRABROKERID = 13;
    public static final int C_CONTRAUSERID = 14;
    public static final int C_PRICE = 15;
    public static final int C_LOT = 16;
    public static final int C_VOLUME = 17;
    public static final int C_ISBASKETORDER = 18;
    public static final int C_BASKETSENDTIME = 19;
    public static final int C_STATUSID = 20;
    public static final int C_TLBEFORE = 21;
    public static final int C_AVPORTBEFORE = 22;
    public static final int C_RATIOBEFORE = 23;
    public static final int C_ISOVERLIMIT = 24;
    public static final int C_ISSHORTSELL = 25;
    public static final int C_MARKETORDERID = 26;
    public static final int C_DONEVOLUME = 27;
    public static final int C_PREVDONEVOLUME = 28;
    public static final int C_PREVORDERID = 29;
    public static final int C_NEXTORDERID = 30;
    public static final int C_PREVMARKETORDERID = 31;
    public static final int C_NEXTMARKETORDERID = 32;
    public static final int C_ENTRYRTTIME = 33;
    public static final int C_ENTRYRTBY = 34;
    public static final int C_ENTRYRTTERMINAL = 35;
    public static final int C_REJECTTIME = 36;
    public static final int C_OPENTIME = 37;
    public static final int C_OPENSENDTIME = 38;
    public static final int C_AMENDTIME = 39;
    public static final int C_AMENDBY = 40;
    public static final int C_AMENDTERMINAL = 41;
    public static final int C_AMENDSENDTIME = 42;
    public static final int C_WITHDRAWTIME = 43;
    public static final int C_WITHDRAWBY = 44;
    public static final int C_WITHDRAWTERMINAL = 45;
    public static final int C_WITHDRAWSENDTIME = 46;
    public static final int C_SPLITTO = 47;
    public static final int C_SPLITBY = 48;
    public static final int C_SPLITTERMINAL = 49;
    public static final int C_MATCHCOUNTER = 50;
    public static final int C_MATCHTIME = 51;
    public static final int C_LQVALUEBEFORE = 52;
    public static final int C_COUNTER = 53;
    public static final int C_TOTALCOUNTERSPLIT = 54;
    public static final int C_NOTE = 55;
    public static final int C_COMPLAINCEID = 56;
    public static final int C_UPDATEDATE = 57;
    public static final int C_USERID = 58;
    public static final int C_UPDATEBY = 59;
    public static final int C_TERMINALID = 60;
    public static final int C_ISFLOOR = 61;
    public static final int C_MYACC = 62;
    public static final int C_BALANCEVOLUME = 63;
    public static final int C_BALANCELOT = 64;
    public static final int C_DONELOT = 65;
    public static final int C_TRADENO = 66;
    public static final int C_MARKETREF = 67;
    public static final int C_NEGDEALREF = 68;
    public static final int C_ACCID = 69;
    public static final int C_ORDERIDCONTRA = 70;
    public static final int C_ACCIDCONTRA = 71;
    public static final int C_INVTYPECONTRA = 72;
    public static final int C_TRADINGIDCONTRA = 73;
    public static final int C_ORDERAMOUNT = 74;
    public static final int C_CLIENTIDNAME = 75;
    public static final int C_ACCOUNTTYPE = 76;
    public static final int C_NEED_APPROVED = 77;
    public static final int C_ISAPPROVED = 78;
    public static final int C_APPROVED_BY = 79;
    public static final int C_APPROVED_TIME = 80;
    public static final int C_APPROVED_STATUS = 81;
    public static final int C_BRANCH_ID = 82;
    public static final int C_AVG_PRICE = 83;
    public static final int C_GTC_DATE = 84;
    public static final int TAG_SPEED_ORDER_DESKTOP = 98;
    public static final String C_BUY = "1";
    public static final String C_SELL = "2";
    public static final String C_DAYORDER = "0";
    public static final String C_SESSIONORDER = "S";
    public static final String C_ENTRY_TEMPORARY = "ET";
    public static final String C_TEMPORARY = "T";
    public static final String C_ENTRY = "o";
    public static final String C_OPEN = "O";
    public static final String C_PARTIAL_MATCH = "P";
    public static final String C_FULL_MATCH = "M";
    public static final String C_DELETE_REQUEST = "RD";
    public static final String C_DELETE = "D";
    public static final String C_WITHDRAW = "W";
    public static final String C_AMEND = "A";
    public static final String C_REQUEST_WITHDRAW = "w";
    public static final String C_REJECTED = "8";
    public static final String C_REJECTED2 = "R";
    public static final String C_REQUEST_AMEND = "a";
    public static final String C_SENDING_ENTRY = "SE";
    public static final String C_SENDING_TEMPORARY = "ST";
    public static final String C_SENDING_DELETE = "SD";
    public static final String C_SENDING_WITHDRAW = "SW";
    public static final String C_SENDING_AMEND = "SA";
    public static final String C_SENDING_ENTRYSERVER = "SES";
    public static final String C_SENDING_TEMPORARYSERVER = "STS";
    public static final String C_SENDING_DELETESERVER = "SDS";
    public static final String C_SENDING_WITHDRAWSERVER = "SWS";
    public static final String C_SENDING_AMENDSERVER = "SAS";
    public static final String C_FAILED = "F";
    public static final String C_SPLIT = "S";
    public String massRequest = "1";
    private String orderid = "";
    private Date orderdate;
    private String xchid = "";
    private String brdid = "";
    private String brokerid = "";
    private String buyorsell = "";
    private String ordtype = "";
    private String ordertype = "";
    private String secid = "";
    private String isadvertising = "";
    private String tradingid = "";
    private String invtype = "";
    private String curid = "";
    private String contrabrokerid = "";
    private String contrauserid = "";
    private Double price = 0.0;
    private Double lot = 0.0;
    private Double volume = 0.0;
    private String isbasketorder = "";
    private Date basketsendtime;
    private String statusid = "";
    private Double lbefore = 0.0;
    private Double avportbefore = 0.0;
    private Double ratiobefore = 0.0;
    private String isoverlimit = "";
    private String isshortsell;
    private String marketorderid;
    private Double donevolume;
    private Double prevdonevolume;
    private String prevorderid;
    private String nextorderid;
    private String prevmarketorderid;
    private String nextmarketorderid;
    private Date entryrttime;
    private String entryrtby = "";
    private String entryrtterminal;
    private Date rejecttime;
    private Date opentime;
    private Date opensendtime;
    private Date amendtime;
    private String amendby = "";
    private String amendterminal;
    private Date amendsendtime;
    private Date withdrawtime;
    private String withdrawby = "";
    private String withdrawterminal;
    private Date withdrawsendtime;
    private Double splitto;
    private String splotby;
    private String splitterminal;
    private Double matchcounter;
    private Date matchtime;
    private Double lqvaluebefore;
    private Double counter;
    private Double totalcountersplit;
    private String note;
    private String complianceid;
    private String complianceidContra = "";
    private Date updatedate;
    private String userid;
    private String updateby;
    private String terminalid;
    private String isfloor;
    private boolean myacc;
    private Double balancevolume;
    private Double balancelot;
    private Double donelot;
    private String tradeno;
    private String marketref;
    private String negdealref;
    private String accid;
    private String orderidcontra = "";
    private String accidcontra = "";
    private String invtypecontra = "";
    private String tradingidcontra = "";
    private Double orderamount;
    private String clientidname;
    private String accounttype;
    private Integer needapproved;
    private Integer isapproved;
    private String approvedby;
    private Date approvedtime;
    private String approvedstatus;
    private String branchid;
    private Double avgprice;
    private Double feebuy = 0.0;
    private Double feesell = 0.0;
    private String isgtc;
    private Date gtcdate;
    private String typeOrder = "";
    private String settleType;
    private Date settleDate;
    protected Vector vcolumn = new Vector();
    public static final int CIDN_NUMBEROFFIELDS = 85;

    public Order() {
        super(85);
    }

    public Order(String[] stringArray, SimpleDateFormat simpleDateFormat) {
        super(85);
        String string = this.convertStr(stringArray[0]);
        String string2 = this.convertStr(stringArray[1]);
        String string3 = this.convertStr(stringArray[2]);
        String string4 = this.convertStr(stringArray[3]);
        String string5 = this.convertStr(stringArray[4]);
        this.setNegDealRef(string);
        this.setOrderIDContra(string2);
        this.setAccIDContra(string3);
        this.setInvTypeContra(string4);
        this.setOrdType(string5);
        this.setId(this.convertStr(stringArray[5]));
        this.setOrderDate(this.convertDate(stringArray[6], simpleDateFormat));
        this.setCurrency(this.convertStr(stringArray[7]));
        this.setExchange(this.convertStr(stringArray[8]));
        this.setBoard(this.convertStr(stringArray[9]));
        this.setBroker(this.convertStr(stringArray[10]));
        this.setBOS(this.convertStr(stringArray[11]));
        this.setOrderType(this.convertStr(stringArray[12]));
        this.setStock(this.convertStr(stringArray[13]));
        this.setIsAdvertising(this.convertStr(stringArray[14]));
        if (this.getIsAdvertising().equals("")) {
            this.setIsAdvertising(C_DAYORDER);
        }
        this.setTradingId(this.convertStr(stringArray[15]));
        this.setInvType(this.convertStr(stringArray[16]));
        this.setContraBroker(this.convertStr(stringArray[17]));
        this.setContraUser(this.convertStr(stringArray[18]));
        this.setPrice(this.convertDouble(stringArray[19]));
        this.setLot(this.convertDouble(stringArray[20]));
        this.setVolume(this.convertDouble(stringArray[21]));
        this.setIsBasketOrder(this.convertStr(stringArray[22]));
        if (this.getIsBasketOrder().equals("")) {
            this.setIsBasketOrder(C_DAYORDER);
        }
        this.setBasketTime(this.convertDate(stringArray[23], simpleDateFormat));
        this.setStatus(this.convertStr(stringArray[24]));
        this.setTLBefore(this.convertDouble(stringArray[25]));
        this.setPortBefore(this.convertDouble(stringArray[26]));
        this.setRatioBefore(this.convertDouble(stringArray[27]));
        this.setIsOverLimit(this.convertStr(stringArray[28]));
        this.setIsShortSell(this.convertStr(stringArray[29]));
        this.setMarketOrderId(this.convertStr(stringArray[30]));
        this.setDoneVol(this.convertDouble(stringArray[31]));
        this.setPrevDoneVolume(this.convertDouble(stringArray[32]));
        this.setPrevOrderId(this.convertStr(stringArray[33]));
        this.setNextOrderId(this.convertStr(stringArray[34]));
        this.setPrevMarketOrderId(this.convertStr(stringArray[35]));
        this.setNextMarketOrderId(this.convertStr(stringArray[36]));
        this.setEntryTime(this.convertDate(stringArray[37], simpleDateFormat));
        this.setEntryBy(this.convertStr(stringArray[38]));
        this.setEntryTerminal(this.convertStr(stringArray[39]));
        this.setRejectTime(this.convertDate(stringArray[40], simpleDateFormat));
        this.setOpenTime(this.convertDate(stringArray[41], simpleDateFormat));
        this.setOpenSendTime(this.convertDate(stringArray[42], simpleDateFormat));
        this.setAmendTime(this.convertDate(stringArray[43], simpleDateFormat));
        this.setAmendBy(this.convertStr(stringArray[44]));
        this.setAmendTerminal(this.convertStr(stringArray[45]));
        this.setAmendSendTime(this.convertDate(stringArray[46], simpleDateFormat));
        this.setWithdrawTime(this.convertDate(stringArray[47], simpleDateFormat));
        this.setWithdrawBy(this.convertStr(stringArray[48]));
        this.setWithdrawTerminal(this.convertStr(stringArray[49]));
        this.setWithdrawSendTime(this.convertDate(stringArray[50], simpleDateFormat));
        this.setSplitTo(this.convertDouble(stringArray[51]));
        this.setSplitBy(this.convertStr(stringArray[52]));
        this.setSplitTerminal(this.convertStr(stringArray[53]));
        this.setMatchCounter(this.convertDouble(stringArray[54]));
        this.setMatchTime(this.convertDate(stringArray[55], simpleDateFormat));
        this.setLQValueBefore(this.convertDouble(stringArray[56]));
        this.setCounter(this.convertDouble(stringArray[57]));
        this.setTotalcounterSplit(this.convertDouble(stringArray[58]));
        this.setNote(this.convertStr(stringArray[59]));
        this.setComplianceId(this.convertStr(stringArray[60]));
        this.setUpdateDate(this.convertDate(stringArray[61], simpleDateFormat));
        this.setUser(this.convertStr(stringArray[62]));
        this.setUpdateBy(this.convertStr(stringArray[63]));
        if (this.getUpdateDate() == null) {
            if (this.getStatus().equals(C_REJECTED2)) {
                this.setUpdateDate(this.getRejectTime());
            } else if (this.getStatus().equals(C_AMEND)) {
                this.setUpdateDate(this.getAmendTime());
            } else if (this.getStatus().equals(C_FULL_MATCH) || this.getStatus().equals(C_PARTIAL_MATCH)) {
                this.setUpdateDate(this.getMatchTime());
            } else if (this.getStatus().contentEquals(C_WITHDRAW) && this.getMatchTime() != null) {
                this.setUpdateDate(this.getMatchTime());
            }
        } else if ((this.getStatus().equals(C_FULL_MATCH) || this.getStatus().equals(C_PARTIAL_MATCH)) && this.getMatchTime() != null) {
            this.setUpdateDate(this.getMatchTime());
        }
        this.setTerminalId(this.convertStr(stringArray[64]));
        this.setIsFloor(this.convertStr(stringArray[65]));
        this.setMyAccount(this.convertStr(stringArray[66]).equals(C_BUY));
        this.setAccId(this.convertStr(stringArray[67]));
        Double d2 = this.convertDouble(stringArray[68]);
        String string6 = this.convertStr(stringArray[69]);
        Double d3 = this.convertDouble(stringArray[70]);
        Date date = this.convertDate(stringArray[71], simpleDateFormat);
        String string7 = this.convertStr(stringArray[72]);
        this.setNeedApproved(d2.intValue());
        this.setApprovedBy(string6);
        this.setIsApproved(d3.intValue());
        this.setApprovedTime(date);
        this.setApprovedStatusy(string7);
        try {
            this.setAVGPrice(this.convertDouble(stringArray[73]));
            this.setFeebuy(this.convertDouble(stringArray[74]));
            this.setFeesell(this.convertDouble(stringArray[75]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMarketref(this.getId());
        this.setCurrency("IDR");
        this.setTradeNo(C_DAYORDER);
        this.setIsgtc(this.convertStr(stringArray[76]));
        this.setGtcdate(this.convertDate(stringArray[77], simpleDateFormat));
        String string8 = stringArray[78];
        if (this.getBoard().contentEquals("NG")) {
            try {
                this.settleType = stringArray[79];
                this.settleDate = simpleDateFormat.parse(stringArray[80]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void calculate() {
        if (this.getOrderIDContra() != null && !this.getOrderIDContra().isEmpty()) {
            this.setLot(this.getVolume() / (double)r.c.intValue());
        }
        double d2 = this.getVolume() / this.getLot();
        this.setBalVol(new Double(this.getVolume() - this.getDoneVol()));
        this.setBalLot(new Double(this.getBalVol() / d2));
        this.setDoneLot(new Double(this.getDoneVol() / d2));
        this.buildAmount();
    }

    public void buildAmount() {
        if (this.getBOS().equals(C_BUY) || this.getBOS().equals(C_FULL_MATCH)) {
            double d2 = Math.floor(this.getVolume() * this.getPrice() * this.getFeebuy());
            if (d2 > 0.0) {
                double d3 = this.getVolume() == 0.0 ? 0.0 : this.getVolume() * this.getPrice() + d2;
                this.setOrderAmount(new Double(d3));
            } else {
                double d4 = this.getVolume() == 0.0 ? 0.0 : this.getVolume() * this.getPrice();
                this.setOrderAmount(new Double(Math.floor(d4)));
            }
        } else if (this.getBOS().equals(C_SELL)) {
            double d5 = this.getVolume() * this.getPrice() * this.getFeesell();
            if (d5 > 0.0) {
                double d6 = this.getVolume() == 0.0 ? 0.0 : this.getVolume() * this.getPrice() - d5;
                this.setOrderAmount(new Double(Math.floor(d6)));
            } else {
                double d7 = this.getVolume() == 0.0 ? 0.0 : this.getVolume() * this.getPrice();
                this.setOrderAmount(new Double(d7));
            }
        }
    }

    public String getIsgtc() {
        return this.isgtc;
    }

    public void setIsgtc(String string) {
        this.isgtc = string;
    }

    public Date getGtcdate() {
        return this.gtcdate;
    }

    public void setGtcdate(Date date) {
        this.gtcdate = date;
    }

    public String getId() {
        return this.orderid;
    }

    public void setId(String string) {
        this.orderid = string;
    }

    public String getOrderId() {
        return this.orderid;
    }

    public void setOrderId(String string) {
        this.orderid = string;
    }

    public Date getOrderDate() {
        return this.orderdate;
    }

    public void setOrderDate(Date date) {
        this.orderdate = date;
    }

    public String getExchange() {
        return this.xchid;
    }

    public void setExchange(String string) {
        this.xchid = string;
    }

    public String getBoard() {
        return this.brdid;
    }

    public void setBoard(String string) {
        this.brdid = string;
    }

    public String getBroker() {
        return this.brokerid;
    }

    public void setBroker(String string) {
        this.brokerid = string;
    }

    public String getBOS() {
        return this.buyorsell;
    }

    public void setBOS(String string) {
        this.buyorsell = string;
    }

    public String getOrdType() {
        return this.ordtype;
    }

    public void setOrdType(String string) {
        this.ordtype = string;
    }

    public String getOrderType() {
        return this.ordertype;
    }

    public void setOrderType(String string) {
        this.ordertype = string;
    }

    public String getStock() {
        return this.secid;
    }

    public void setStock(String string) {
        this.secid = string;
    }

    public String getIsAdvertising() {
        return this.isadvertising;
    }

    public void setIsAdvertising(String string) {
        this.isadvertising = string;
    }

    public String getTradingId() {
        return this.tradingid;
    }

    public void setTradingId(String string) {
        this.tradingid = string;
    }

    public String getInvType() {
        return this.invtype;
    }

    public void setInvType(String string) {
        this.invtype = string;
    }

    public String getCurrency() {
        return this.curid;
    }

    public void setCurrency(String string) {
        this.curid = string;
    }

    public String getContraBroker() {
        return this.contrabrokerid;
    }

    public void setContraBroker(String string) {
        this.contrabrokerid = string;
    }

    public String getContraUser() {
        return this.contrauserid;
    }

    public void setContraUser(String string) {
        this.contrauserid = string;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double d2) {
        this.price = d2;
    }

    public Double getLot() {
        return this.lot;
    }

    public void setLot(Double d2) {
        this.lot = d2;
    }

    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double d2) {
        this.volume = d2;
    }

    public String getIsBasketOrder() {
        return this.isbasketorder;
    }

    public void setIsBasketOrder(String string) {
        this.isbasketorder = string;
    }

    public Date getBasketTime() {
        return this.basketsendtime;
    }

    public void setBasketTime(Date date) {
        this.basketsendtime = date;
    }

    public String getStatus() {
        return this.statusid;
    }

    public void setStatus(String string) {
        this.statusid = string;
    }

    public Double getTLBefore() {
        return this.lbefore;
    }

    public void setTLBefore(Double d2) {
        this.lbefore = d2;
    }

    public Double getPortBefore() {
        return this.avportbefore;
    }

    public void setPortBefore(Double d2) {
        this.avportbefore = d2;
    }

    public Double getRatioBefore() {
        return this.ratiobefore;
    }

    public void setRatioBefore(Double d2) {
        this.ratiobefore = d2;
    }

    public String getIsOverLimit() {
        return this.isoverlimit;
    }

    public void setIsOverLimit(String string) {
        this.isoverlimit = string;
    }

    public String getIsShortSell() {
        return this.isshortsell;
    }

    public void setIsShortSell(String string) {
        this.isshortsell = string;
    }

    public String getMarketOrderId() {
        return this.marketorderid;
    }

    public void setMarketOrderId(String string) {
        this.marketorderid = string;
    }

    public Double getDoneVol() {
        return this.donevolume;
    }

    public void setDoneVol(Double d2) {
        this.donevolume = d2;
    }

    public Double getPrevDoneVolume() {
        return this.prevdonevolume;
    }

    public void setPrevDoneVolume(Double d2) {
        this.prevdonevolume = d2;
    }

    public String getPrevOrderId() {
        return this.prevorderid;
    }

    public void setPrevOrderId(String string) {
        this.prevorderid = string;
    }

    public String getNextOrderId() {
        return this.nextorderid;
    }

    public void setNextOrderId(String string) {
        this.nextorderid = string;
    }

    public String getPrevMarketOrderId() {
        return this.prevmarketorderid;
    }

    public void setPrevMarketOrderId(String string) {
        this.prevmarketorderid = string;
    }

    public String getNextMarketOrderId() {
        return this.nextmarketorderid;
    }

    public void setNextMarketOrderId(String string) {
        this.nextmarketorderid = string;
    }

    public Date getEntryTime() {
        return this.entryrttime;
    }

    public void setEntryTime(Date date) {
        this.entryrttime = date;
    }

    public String getEntryBy() {
        return this.entryrtby;
    }

    public void setEntryBy(String string) {
        this.entryrtby = string;
    }

    public String getEntryTerminal() {
        return this.entryrtterminal;
    }

    public void setEntryTerminal(String string) {
        this.entryrtterminal = string;
    }

    public Date getRejectTime() {
        return this.rejecttime;
    }

    public void setRejectTime(Date date) {
        this.rejecttime = date;
    }

    public Date getOpenTime() {
        return this.opentime;
    }

    public void setOpenTime(Date date) {
        this.opentime = date;
    }

    public Date getOpenSendTime() {
        return this.opensendtime;
    }

    public void setOpenSendTime(Date date) {
        this.opensendtime = date;
    }

    public Date getAmendTime() {
        return this.amendtime;
    }

    public void setAmendTime(Date date) {
        this.amendtime = date;
    }

    public String getAmendBy() {
        return this.amendby;
    }

    public void setAmendBy(String string) {
        this.amendby = string;
    }

    public String getAmendTerminal() {
        return this.amendterminal;
    }

    public void setAmendTerminal(String string) {
        this.amendterminal = string;
    }

    public Date getAmendSendTime() {
        return this.amendsendtime;
    }

    public void setAmendSendTime(Date date) {
        this.amendsendtime = date;
    }

    public Date getWithdrawTime() {
        return this.withdrawtime;
    }

    public void setWithdrawTime(Date date) {
        this.withdrawtime = date;
    }

    public String getWithdrawBy() {
        return this.withdrawby;
    }

    public void setWithdrawBy(String string) {
        this.withdrawby = string;
    }

    public String getWithdrawTerminal() {
        return this.withdrawterminal;
    }

    public void setWithdrawTerminal(String string) {
        this.withdrawterminal = string;
    }

    public Date getWithdrawSendTime() {
        return this.withdrawsendtime;
    }

    public void setWithdrawSendTime(Date date) {
        this.withdrawsendtime = date;
    }

    public Double getSplitTo() {
        return this.splitto;
    }

    public void setSplitTo(Double d2) {
        this.splitto = d2;
    }

    public String getSplitBy() {
        return this.splotby == null ? "" : this.splotby;
    }

    public void setSplitBy(String string) {
        this.splotby = string;
    }

    public String getSplitTerminal() {
        return this.splitterminal;
    }

    public void setSplitTerminal(String string) {
        this.splitterminal = string;
    }

    public Double getMatchCounter() {
        return this.matchcounter;
    }

    public void setMatchCounter(Double d2) {
        this.matchcounter = d2;
    }

    public Date getMatchTime() {
        return this.matchtime;
    }

    public void setMatchTime(Date date) {
        this.matchtime = date;
    }

    public Double getLQValueBefore() {
        return this.lqvaluebefore;
    }

    public void setLQValueBefore(Double d2) {
        this.lqvaluebefore = d2;
    }

    public Double getCounter() {
        return this.counter;
    }

    public void setCounter(Double d2) {
        this.counter = d2;
    }

    public Double getTotalcounterSplit() {
        return this.totalcountersplit;
    }

    public void setTotalcounterSplit(Double d2) {
        this.totalcountersplit = d2;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public String getComplianceId() {
        return this.complianceid;
    }

    public void setComplianceId(String string) {
        this.complianceid = string;
    }

    public String getComplianceIdContra() {
        return this.complianceidContra;
    }

    public void setComplianceIdContra(String string) {
        this.complianceidContra = string;
    }

    public Date getUpdateDate() {
        return this.updatedate;
    }

    public void setUpdateDate(Date date) {
        this.updatedate = date;
    }

    public String getUser() {
        return this.userid;
    }

    public void setUser(String string) {
        this.userid = string;
    }

    public String getUpdateBy() {
        return this.updateby;
    }

    public void setUpdateBy(String string) {
        this.updateby = string;
    }

    public String getTerminalId() {
        return this.terminalid;
    }

    public void setTerminalId(String string) {
        this.terminalid = string;
    }

    public String getIsFloor() {
        return this.isfloor;
    }

    public void setIsFloor(String string) {
        this.isfloor = string;
    }

    public boolean getMyAccount() {
        return this.myacc;
    }

    public void setMyAccount(boolean bl2) {
        this.myacc = bl2;
    }

    public Double getBalVol() {
        return this.balancevolume;
    }

    public void setBalVol(Double d2) {
        this.balancevolume = d2;
    }

    public Double getBalLot() {
        return this.balancelot;
    }

    public void setBalLot(Double d2) {
        this.balancelot = d2;
    }

    public Double getDoneLot() {
        return this.donelot;
    }

    public void setDoneLot(Double d2) {
        this.donelot = d2;
    }

    public String getTradeNo() {
        return this.tradeno;
    }

    public void setTradeNo(String string) {
        this.tradeno = string;
    }

    public String getMarketref() {
        return this.marketref;
    }

    public void setMarketref(String string) {
        this.marketref = string;
    }

    public String getNegDealRef() {
        return this.negdealref;
    }

    public void setNegDealRef(String string) {
        this.negdealref = string;
    }

    public String getAccId() {
        return this.accid;
    }

    public void setAccId(String string) {
        this.accid = string;
    }

    public String getOrderIDContra() {
        return this.orderidcontra;
    }

    public void setOrderIDContra(String string) {
        this.orderidcontra = string;
    }

    public String getAccIDContra() {
        return this.accidcontra;
    }

    public void setAccIDContra(String string) {
        this.accidcontra = string;
    }

    public String getInvTypeContra() {
        return this.invtypecontra;
    }

    public void setInvTypeContra(String string) {
        this.invtypecontra = string;
    }

    public String getTradingIDContra() {
        return this.tradingidcontra;
    }

    public void setTradingIDContra(String string) {
        this.tradingidcontra = string;
    }

    public Double getOrderAmount() {
        return this.orderamount;
    }

    public Double getAmount() {
        return this.orderamount;
    }

    public void setOrderAmount(Double d2) {
        this.orderamount = d2;
    }

    public String getClientIDName() {
        return this.clientidname;
    }

    public void setClientIDName(String string) {
        this.clientidname = string;
    }

    public String getAccounttype() {
        return this.accounttype;
    }

    public void setAccounttype(String string) {
        this.accounttype = string;
    }

    public void setAccType(String string) {
        this.accounttype = string;
    }

    public Integer getNeedApproved() {
        return this.needapproved;
    }

    public void setNeedApproved(Integer n2) {
        this.needapproved = n2;
    }

    public Integer getIsApproved() {
        return this.isapproved;
    }

    public void setIsApproved(Integer n2) {
        this.isapproved = n2;
    }

    public String getApprovedBy() {
        return this.approvedby;
    }

    public void setApprovedBy(String string) {
        this.approvedby = string;
    }

    public Date getApprovedTime() {
        return this.approvedtime;
    }

    public void setApprovedTime(Date date) {
        this.approvedtime = date;
    }

    public String getApprovedStatus() {
        return this.approvedstatus;
    }

    public void setApprovedStatusy(String string) {
        this.approvedstatus = string;
    }

    public String getBranchId() {
        return this.branchid;
    }

    public void setBranchId(String string) {
        this.branchid = string;
    }

    public Double getAVGPrice() {
        return this.avgprice;
    }

    public void setAVGPrice(Double d2) {
        this.avgprice = d2;
    }

    public String getTypeOrder() {
        return this.typeOrder;
    }

    public void setTypeOrder(String string) {
        this.typeOrder = string;
    }

    public Double convertDouble(String string) {
        return Double.parseDouble(string);
    }

    public String toStringbb() {
        return "Order [orderid=" + this.orderid + ", brdid=" + this.brdid + ", buyorsell=" + this.buyorsell + ", ordtype=" + this.ordtype + ", ordertype=" + this.ordertype + ", secid=" + this.secid + ", tradingid=" + this.tradingid + ", price=" + this.price + ", lot=" + this.lot + ", volume=" + this.volume + ", isbasketorder=" + this.isbasketorder + ", basketsendtime=" + this.basketsendtime + ", statusid=" + this.statusid + ", donevolume=" + this.donevolume + ", entryrtby=" + this.entryrtby + ", splitto=" + this.splitto + ", note=" + this.note + ", donelot=" + this.donelot + ", tradeno=" + this.tradeno + ", accid=" + this.accid + "]";
    }

    public String toString() {
        return "Order [orderid=" + this.orderid + ", brdid=" + this.brdid + ", buyorsell=" + this.buyorsell + ", secid=" + this.secid + ", tradingid=" + this.tradingid + ", price=" + this.price + ", lot=" + this.lot + ", volume=" + this.volume + ", statusid=" + this.statusid + ", splitto=" + this.splitto + ", note=" + this.note + ", balancelot=" + this.balancelot + ", donelot=" + this.donelot + "]";
    }

    public String convertStr(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("null")) {
            return "";
        }
        return string;
    }

    public Date convertDate(String string, SimpleDateFormat simpleDateFormat) {
        if (string.equals("null")) {
            return null;
        }
        try {
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getData(int n2) {
        switch (n2) {
            case 0: {
                return this.getOrderId();
            }
            case 1: {
                return this.getOrderDate();
            }
            case 2: {
                return this.getExchange();
            }
            case 3: {
                return this.getBoard();
            }
            case 4: {
                return this.getBroker();
            }
            case 5: {
                return this.getBOS();
            }
            case 6: {
                return this.getOrdType();
            }
            case 7: {
                return this.getOrderType();
            }
            case 8: {
                return this.getStock();
            }
            case 9: {
                return this.getIsAdvertising();
            }
            case 10: {
                return this.getTradingId();
            }
            case 11: {
                return this.getInvType();
            }
            case 12: {
                return this.getCurrency();
            }
            case 13: {
                return this.getContraBroker();
            }
            case 14: {
                return this.getContraUser();
            }
            case 15: {
                return this.getPrice();
            }
            case 16: {
                return this.getLot();
            }
            case 17: {
                return this.getVolume();
            }
            case 18: {
                return this.getIsBasketOrder();
            }
            case 19: {
                return this.getBasketTime();
            }
            case 20: {
                return this.getStatus();
            }
            case 21: {
                return this.getTLBefore();
            }
            case 22: {
                return this.getPortBefore();
            }
            case 23: {
                return this.getRatioBefore();
            }
            case 24: {
                return this.getIsOverLimit();
            }
            case 25: {
                return this.getIsShortSell();
            }
            case 26: {
                return this.getMarketOrderId();
            }
            case 27: {
                return this.getDoneVol();
            }
            case 28: {
                return this.getPrevDoneVolume();
            }
            case 29: {
                return this.getPrevOrderId();
            }
            case 30: {
                return this.getNextOrderId();
            }
            case 31: {
                return this.getPrevMarketOrderId();
            }
            case 32: {
                return this.getNextMarketOrderId();
            }
            case 33: {
                return this.getEntryTime();
            }
            case 34: {
                return this.getEntryBy();
            }
            case 35: {
                return this.getEntryTerminal();
            }
            case 36: {
                return this.getRejectTime();
            }
            case 37: {
                return this.getOpenTime();
            }
            case 38: {
                return this.getOpenSendTime();
            }
            case 39: {
                return this.getAmendTime();
            }
            case 40: {
                return this.getAmendBy();
            }
            case 41: {
                return this.getAmendTerminal();
            }
            case 42: {
                return this.getAmendSendTime();
            }
            case 43: {
                return this.getWithdrawTime();
            }
            case 44: {
                return this.getWithdrawBy();
            }
            case 45: {
                return this.getWithdrawTerminal();
            }
            case 46: {
                return this.getWithdrawSendTime();
            }
            case 47: {
                return this.getSplitTo();
            }
            case 48: {
                return this.getSplitBy();
            }
            case 49: {
                return this.getSplitTerminal();
            }
            case 50: {
                return this.getMatchCounter();
            }
            case 51: {
                return this.getMatchTime();
            }
            case 52: {
                return this.getLQValueBefore();
            }
            case 53: {
                return this.getCounter();
            }
            case 54: {
                return this.getTotalcounterSplit();
            }
            case 55: {
                return this.getNote();
            }
            case 56: {
                return this.getComplianceId();
            }
            case 57: {
                return this.getUpdateDate();
            }
            case 58: {
                return this.getUser();
            }
            case 59: {
                return this.getUpdateBy();
            }
            case 60: {
                return this.getTerminalId();
            }
            case 61: {
                return this.getIsFloor();
            }
            case 62: {
                return this.getMyAccount();
            }
            case 63: {
                return this.getBalVol();
            }
            case 64: {
                return this.getBalLot();
            }
            case 65: {
                return this.getDoneLot();
            }
            case 66: {
                return this.getTradeNo();
            }
            case 67: {
                return this.getMarketref();
            }
            case 68: {
                return this.getNegDealRef();
            }
            case 69: {
                return this.getAccId();
            }
            case 70: {
                return this.getOrderIDContra();
            }
            case 71: {
                return this.getAccIDContra();
            }
            case 72: {
                return this.getInvTypeContra();
            }
            case 73: {
                return this.getTradingIDContra();
            }
            case 74: {
                return this.getOrderAmount();
            }
            case 75: {
                return this.getClientIDName();
            }
            case 76: {
                return this.getAccounttype();
            }
            case 77: {
                return this.getNeedApproved();
            }
            case 78: {
                return this.getIsApproved();
            }
            case 79: {
                return this.getApprovedBy();
            }
            case 80: {
                return this.getApprovedTime();
            }
            case 81: {
                return this.getApprovedStatus();
            }
            case 82: {
                return this.getBranchId();
            }
            case 83: {
                return this.getAVGPrice();
            }
            case 84: {
                return this.getGtcdate();
            }
        }
        return null;
    }

    @Override
    public void setData(Object object, int n2) {
        switch (n2) {
            case 0: {
                this.setOrderId((String)object);
                break;
            }
            case 1: {
                this.setOrderDate((Date)object);
                break;
            }
            case 2: {
                this.setExchange((String)object);
                break;
            }
            case 3: {
                this.setBoard((String)object);
                break;
            }
            case 4: {
                this.setBroker((String)object);
                break;
            }
            case 5: {
                this.setBOS((String)object);
                break;
            }
            case 6: {
                this.setOrdType((String)object);
                break;
            }
            case 7: {
                this.setOrderType((String)object);
                break;
            }
            case 8: {
                this.setStock((String)object);
                break;
            }
            case 9: {
                this.setIsAdvertising((String)object);
                break;
            }
            case 10: {
                this.setTradingId((String)object);
                break;
            }
            case 11: {
                this.setInvType((String)object);
                break;
            }
            case 12: {
                this.setCurrency((String)object);
                break;
            }
            case 13: {
                this.setContraBroker((String)object);
                break;
            }
            case 14: {
                this.setContraUser((String)object);
                break;
            }
            case 15: {
                this.setPrice((Double)object);
                break;
            }
            case 16: {
                this.setLot((Double)object);
                break;
            }
            case 17: {
                this.setVolume((Double)object);
                break;
            }
            case 18: {
                this.setIsBasketOrder((String)object);
                break;
            }
            case 19: {
                this.setBasketTime((Date)object);
                break;
            }
            case 20: {
                this.setStatus((String)object);
                break;
            }
            case 21: {
                this.setTLBefore((Double)object);
                break;
            }
            case 22: {
                this.setPortBefore((Double)object);
                break;
            }
            case 23: {
                this.setRatioBefore((Double)object);
                break;
            }
            case 24: {
                this.setIsOverLimit((String)object);
                break;
            }
            case 25: {
                this.setIsShortSell((String)object);
                break;
            }
            case 26: {
                this.setMarketOrderId((String)object);
                break;
            }
            case 27: {
                this.setDoneVol((Double)object);
                break;
            }
            case 28: {
                this.setPrevDoneVolume((Double)object);
                break;
            }
            case 29: {
                this.setPrevOrderId((String)object);
                break;
            }
            case 30: {
                this.setNextOrderId((String)object);
                break;
            }
            case 31: {
                this.setPrevMarketOrderId((String)object);
                break;
            }
            case 32: {
                this.setNextMarketOrderId((String)object);
                break;
            }
            case 33: {
                this.setEntryTime((Date)object);
                break;
            }
            case 34: {
                this.setEntryBy((String)object);
                break;
            }
            case 35: {
                this.setEntryTerminal((String)object);
                break;
            }
            case 36: {
                this.setRejectTime((Date)object);
                break;
            }
            case 37: {
                this.setOpenTime((Date)object);
                break;
            }
            case 38: {
                this.setOpenSendTime((Date)object);
                break;
            }
            case 39: {
                this.setAmendTime((Date)object);
                break;
            }
            case 40: {
                this.setAmendBy((String)object);
                break;
            }
            case 41: {
                this.setAmendTerminal((String)object);
                break;
            }
            case 42: {
                this.setAmendSendTime((Date)object);
                break;
            }
            case 43: {
                this.setWithdrawTime((Date)object);
                break;
            }
            case 44: {
                this.setWithdrawBy((String)object);
                break;
            }
            case 45: {
                this.setWithdrawTerminal((String)object);
                break;
            }
            case 46: {
                this.setWithdrawSendTime((Date)object);
                break;
            }
            case 47: {
                this.setSplitTo((Double)object);
                break;
            }
            case 48: {
                this.setSplitBy((String)object);
                break;
            }
            case 49: {
                this.setSplitTerminal((String)object);
                break;
            }
            case 50: {
                this.setMatchCounter((Double)object);
                break;
            }
            case 51: {
                this.setMatchTime((Date)object);
                break;
            }
            case 52: {
                this.setLQValueBefore((Double)object);
                break;
            }
            case 53: {
                this.setCounter((Double)object);
                break;
            }
            case 54: {
                this.setTotalcounterSplit((Double)object);
                break;
            }
            case 55: {
                this.setNote((String)object);
                break;
            }
            case 56: {
                this.setComplianceId((String)object);
                break;
            }
            case 57: {
                this.setUpdateDate((Date)object);
                break;
            }
            case 58: {
                this.setUser((String)object);
                break;
            }
            case 59: {
                this.setUpdateBy((String)object);
                break;
            }
            case 60: {
                this.setTerminalId((String)object);
                break;
            }
            case 61: {
                this.setIsFloor((String)object);
                break;
            }
            case 62: {
                this.setMyAccount((Boolean)object);
                break;
            }
            case 63: {
                this.setBalVol((Double)object);
                break;
            }
            case 64: {
                this.setBalLot((Double)object);
                break;
            }
            case 65: {
                this.setDoneLot((Double)object);
                break;
            }
            case 66: {
                this.setTradeNo((String)object);
                break;
            }
            case 67: {
                this.setMarketref((String)object);
                break;
            }
            case 68: {
                this.setNegDealRef((String)object);
                break;
            }
            case 69: {
                this.setAccId((String)object);
                break;
            }
            case 70: {
                this.setOrderIDContra((String)object);
                break;
            }
            case 71: {
                this.setAccIDContra((String)object);
                break;
            }
            case 72: {
                this.setInvTypeContra((String)object);
                break;
            }
            case 73: {
                this.setTradingIDContra((String)object);
                break;
            }
            case 74: {
                this.setOrderAmount((Double)object);
                break;
            }
            case 75: {
                this.setClientIDName((String)object);
                break;
            }
            case 76: {
                this.setAccounttype((String)object);
                break;
            }
            case 77: {
                this.setNeedApproved((Integer)object);
                break;
            }
            case 78: {
                this.setIsApproved((Integer)object);
                break;
            }
            case 79: {
                this.setApprovedBy((String)object);
                break;
            }
            case 80: {
                this.setApprovedTime((Date)object);
                break;
            }
            case 81: {
                this.setApprovedStatusy((String)object);
                break;
            }
            case 82: {
                this.setBranchId((String)object);
                break;
            }
            case 83: {
                this.setAVGPrice((Double)object);
                break;
            }
            case 84: {
                this.setGtcdate((Date)object);
                break;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 85;
    }

    public void updateVolume(double d2) {
        if (this.getData(17) != null) {
            double d3 = (Double)this.getData(17) / (Double)this.getData(16);
            double d4 = d2 - (Double)this.getData(17);
            double d5 = (Double)this.getData(63) + d4;
            this.setBalVol(new Double(d5));
            this.setLot(new Double(d2 / d3));
            this.setVolume(new Double(d2));
            this.setBalLot(new Double(d5 / d3));
        } else {
            this.setVolume(new Double(d2));
        }
        this.buildAmount();
    }

    public char getHandInst() {
        if (this.getIsAdvertising().equals(C_DAYORDER)) {
            return this.getBoard().equals("NG") ? (char)'3' : '1';
        }
        return '2';
    }

    public void setMarketRef(String string) {
        this.marketref = string;
    }

    public Double getFeebuy() {
        return this.feebuy;
    }

    public void setFeebuy(Double d2) {
        this.feebuy = d2;
    }

    public Double getFeesell() {
        return this.feesell;
    }

    public void setFeesell(Double d2) {
        this.feesell = d2;
    }

    @Override
    public int getColumnSize() {
        return 85;
    }

    public String getSettleType() {
        return this.settleType;
    }

    public void setSettleType(String string) {
        this.settleType = string;
    }

    public Date getSettleDate() {
        return this.settleDate;
    }

    public void setSettleDate(Date date) {
        this.settleDate = date;
    }

    public Object clone() {
        Order order = new Order();
        for (int i2 = 0; i2 < 85; ++i2) {
            order.setData(this.getData(i2), i2);
        }
        return order;
    }

    public boolean isOrderAutoForcsell() {
        return this.splitto != null && this.splitto >= 80.0 && this.splitto <= 82.0;
    }
}

