/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d.addon;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class StatusBarPainter
extends de.javasoft.syntheticaaddons.ui.painter.StatusBarPainter {
    public void paintStatusBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            return;
        }
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
        Shape s = this.createShape(0.0f, 0.0f, w, h);
        g2.setPaint(new Color(0xEFEFEF));
        g2.fill(s);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xFFFFFFF, true), new Color(0x7000000, true), new Color(0xF000000, true), new Color(0x1F000000, true)}));
        g2.fill(s);
        if (this.isResizeHandleVisible(c)) {
            Insets ins = SyntheticaLookAndFeel.getInsets((String)"Synthetica.statusBar.insets", (Component)c);
            float handleSize = (float)ins.right * this.getScale();
            this.paintResizeHandle(g2, (float)w - handleSize + 1.0f, (float)h - handleSize + 1.0f, handleSize);
        }
        this.restoreGraphics2D(g2);
    }

    private void paintResizeHandle(Graphics2D g2, float x, float y, float handleSize) {
        int bumpSize = (int)(3.0f * this.getScale());
        int bumpGap = (int)(1.0f * this.getScale());
        int size = bumpSize + bumpGap;
        int bumps = (int)((handleSize + (float)bumpGap) / (float)size);
        if (this.getScale() == 1.0f) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        float x_ = x;
        float y_ = y;
        int i = 0;
        while (i < bumps) {
            x_ = x + handleSize - 1.0f;
            int j = 0;
            while (j < i + 1) {
                this.paintBump(g2, x_ -= (float)size, y_, bumpSize);
                ++j;
            }
            y_ += (float)size;
            ++i;
        }
    }

    private void paintBump(Graphics2D g2, float x, float y, float bumpSize) {
        float scale = this.getScale();
        Shape s = this.createShape(x, y, bumpSize - scale, bumpSize - scale);
        g2.setPaint(new Color(0xC3C3C3));
        g2.fill(s);
        s = this.createShape(x, y + bumpSize - scale, bumpSize - scale, scale);
        g2.setPaint(new Color(0xF0F0F0));
        g2.fill(s);
        s = this.createShape(x + bumpSize - scale, y, scale, bumpSize);
        g2.setPaint(this.createLinearGradientPaint(x, y, x, y + bumpSize - 1.0f, new float[]{0.67f, 0.671f}, new Color[]{new Color(0xF0F0F0), new Color(0xFCFCFC)}));
        g2.fill(s);
    }

    private Shape createShape(float x, float y, float w, float h) {
        return new Rectangle2D.Float(x, y, w, h);
    }
}

