/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d.addon;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class DockingPainter
extends SyntheticaAddonsPainter {
    private static final float ARC = 8.0f;

    public static DockingPainter getInstance() {
        return DockingPainter.getInstance(null);
    }

    public static DockingPainter getInstance(SynthContext sc) {
        Object instance = instances.get(DockingPainter.getPainterClassName((SynthContext)sc, DockingPainter.class, (String)"Synthetica.DockingPainter"));
        if (instance == null) {
            instance = DockingPainter.getInstance((SynthContext)sc, DockingPainter.class, (String)"Synthetica.DockingPainter");
        }
        return (DockingPainter)((Object)instance);
    }

    public void paintDockingTitleBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
        int borderWidth = 1;
        float arc = this.scaleArc(8.0f);
        Shape shape = this.createTitleBarShape(0.0f, 0.0f, DockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), DockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)1.0f), arc);
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xF5FCFF), new Color(15595516), new Color(15069172), new Color(13623527)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xF0F0F0), new Color(0xE7E7E7), new Color(0xE1E1E1), new Color(0xD2D2D2)}));
        }
        g2.fill(DockingPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        this.restoreGraphics2D(g2);
        g2 = this.prepareGraphics2D(null, g, x, y, true);
        shape = this.createTitleBarShape(0.0f, 0.0f, DockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), DockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0xB2B2B2), new Color(0x808080)}));
        g2.draw(shape);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)}));
        shape = this.createTitleBarShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), DockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), DockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f));
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    private Shape createTitleBarShape(float x, float y, float w, float h, float arc) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + h);
        path.lineTo(x, arc /= 2.0f);
        path.quadTo(x, y, x + arc, y);
        path.lineTo(x + w - arc, y);
        path.quadTo(x + w, y, x + w, y + arc);
        path.lineTo(x + w, y + h);
        return path;
    }

    public void paintDockingContentPaneBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Boolean opaque = c.getClientProperty("Synthetica.opaque") == null ? true : (Boolean)c.getClientProperty("Synthetica.opaque");
        if (!opaque.booleanValue()) {
            return;
        }
        g.setColor(SyntheticaLookAndFeel.getColor((String)"JYDocking.contentPane.border.color", (Component)c));
        g.drawRect(x, y, w - 1, h - 1);
    }

    public void paintDockingDockbarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Point p1 = new Point();
        Point p2 = new Point();
        g.setColor(new Color(208, 208, 208));
        this.calcLinePoints(x, y, w, h, placement, false, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.setColor(Color.WHITE);
        this.calcLinePoints(x, y, w, h, placement, true, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void paintDockingDockbarLabelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true, true);
        g2.setPaint(SyntheticaLookAndFeel.getColor((String)"JYDocking.dockbarLabel.border.color", (Component)c, (Color)Color.LIGHT_GRAY));
        Shape shape = this.createDockbarLabelShape(x, y, w - 1, h - 1, 4.0f);
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    public void paintDockingSlidePanelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        this.paintDockingDockbarBackground(c, state, g, x, y, w, h, placement);
    }

    private void calcLinePoints(int x, int y, int w, int h, int placement, boolean innerLine, Point p1, Point p2) {
        p1.x = x;
        p1.y = y;
        p2.x = x--;
        p2.y = y;
        if (placement == 3) {
            if (innerLine) {
                ++p1.y;
                ++p2.y;
            }
            p2.x = x + w - 1;
        } else if (placement == 4) {
            if (innerLine) {
                ++p1.x;
                ++p2.x;
            }
            p2.y = y + h - 1;
        } else {
            if (innerLine) {
                // empty if block
            }
            p1.x = x + w - 1;
            p2.x = x + w - 1;
            p2.y = y + h - 1;
        }
    }

    private Shape createDockbarLabelShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }
}

